---
id: 66f53dc2c5bd6a11d6c3282f
title: Build a Password Generator App
challengeType: 26
dashedName: lab-password-generator
---

# --description--

In this lab, you'll practice using functions by building a random password generator.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should create a function called `generatePassword` that takes a parameter, indicating the length of generated password. You can name the parameter whatever you like.
2. Your function should return a string which represents a randomly generated password. You should use the following string and different `Math` methods to help you return a new string with random characters in it: `ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()`.
3. You should define a variable called `password` and assign it the result of calling the `generatePassword` function with a numeric argument that represents the desired password length.
4. You should have a `console.log` that logs a single string made by concatenating the message `Generated password:` and the `password` variable separated by a space.

# --hints--

You should have a `generatePassword` function with a parameter. You can name the parameter whatever you like.

```js
assert.isFunction(generatePassword);
assert.lengthOf(generatePassword, 1);
```

Your `generatePassword` function should return a string.

```js
const result = generatePassword(5);
assert.isString(result);
```

Your `generatePassword` function should return a new string that is the correct length.

```js
const length = 8;
const password = generatePassword(length);
assert.lengthOf(password, length);
```

Your function should return a randomly generated password with valid characters.

```js
const validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()";
const password = generatePassword(10);
for (let char of password) {
    assert.include(validChars, char);
}
```

Your function should return a randomly generated password which contains more than one unique character.

```js
const passwordSetSize1 = new Set(generatePassword(12)).size;
const passwordSetSize2 = new Set(generatePassword(12)).size;
const passwordSetSize3 = new Set(generatePassword(12)).size;
assert.isAbove(passwordSetSize1 + passwordSetSize2 + passwordSetSize3, 3);
```

Your function should return a new random string each time it is called.

```js
const password1 = generatePassword(10);
const password2 = generatePassword(10);
assert.notStrictEqual(password1, password2);
```

You should have a `password` variable.

```js
assert.isDefined(password);
```

Your `password` variable should be a string.

```js
assert.isString(password);
```

You should call the `generatePassword` function with a numeric argument and store the returned password in the `password` variable.

```js
assert.isDefined(password);
assert.isString(password);
assert.match(password, /^[A-Za-z0-9!@#$%^&*()]+$/);
const length2 = 10;
const password3 = generatePassword(length2);
assert.lengthOf(password3, length2);
assert.equal(password3.length, generatePassword(length2).length);
assert.match(__helpers.removeJSComments(code), /(let|const|var)\s+password\s*=\s*generatePassword\(\d+\)\;?/);
```

You should log a single string combining `Generated password:` and the `password` separated by a single space using `+` or a template literal.

```js
const cleanCode = __helpers.removeJSComments(code);
const condition1 = /console\.log\(\s*["']Generated\s+password:\s*["']\s*\+\s*password\s*\);?/gm.test(cleanCode);
const condition2 = /console\.log\(\s*`Generated\s+password:\s*\$\{password\}`\s*\);?/gm.test(cleanCode);
assert.isTrue(condition1 || condition2);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
const generatePassword = (length) => {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()";
    let password = "";
    for (let i = 0; i < length; i++) {
        const randomIndex = Math.floor(Math.random() * chars.length);
        password += chars[randomIndex];
    }
    return password;
};

const password = generatePassword(12);
console.log(`Generated password: ${password}`);
```
