---
id: 6842a6cd9836f0114a5b7a8a
title: Build a Number Pattern Generator
challengeType: 27
dashedName: build-a-number-pattern-generator
---

# --description--

In this lab you will practice the basics of Python by building a small app that creates a number pattern.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should define a function named `number_pattern` that takes a single parameter `n` (representing a positive integer).
1. `number_pattern` should use a `for` loop.
1. `number_pattern(n)` should return a string with all the integers starting from 1 up to `n` (included) separated by a space. For example, `number_pattern(4)` should return the string `1 2 3 4`.
1. If the argument passed to the function is not an integer value, the function should return `Argument must be an integer value.`.
1. If the argument passed to the function is less than 1, the function should return `Argument must be an integer greater than 0.`.

# --hints--

You should have a `number_pattern` function.

```js
({
    test: () => runPython(`
    assert _Node(_code).has_function('number_pattern')
    `)
})
```

The `number_pattern` function should have one parameter named `n`.

```js
({
    test: () => runPython(`
    assert _Node(_code).find_function('number_pattern').has_args('n')
    `)
})
```

`number_pattern(4)` should return `1 2 3 4`.

```js
({
    test: () => runPython(`
    assert number_pattern(4) == '1 2 3 4'
    `)
})
```

`number_pattern(12)` should return `1 2 3 4 5 6 7 8 9 10 11 12`.

```js
({
    test: () => runPython(`
    assert number_pattern(12) == '1 2 3 4 5 6 7 8 9 10 11 12'
    `)
})
```

`number_pattern` should return a space separated list of numbers for any positive integer.

```js
({
    test: () => runPython(`
    from random import randint
    n = randint(1,65)
    ls = ' '.join(map(lambda n: str(n), list(range(1, n+1))))
    assert number_pattern(n) == ls

    n2 = randint(34,122)
    ls2 = ' '.join(map(lambda n: str(n), list(range(1, n2+1))))
    assert number_pattern(n2) == ls2
    
    `)
})
```

`number_pattern` should return `Argument must be an integer value.` when passed a value that is not an integer.

```js
({
    test: () => runPython(`
    string = 'Argument must be an integer value.'
    assert number_pattern('a') == string
    assert number_pattern(3.5) == string
    assert number_pattern(lambda n: n) == string
    `)
})
```

`number_pattern` should return `Argument must be an integer greater than 0.` when passed a non-positive integer.

```js
({
    test: () => runPython(`
    from random import randint
    string = 'Argument must be an integer greater than 0.'
    assert number_pattern(0) == string
    assert number_pattern(-1185) == string
    assert number_pattern(-45) == string
    assert number_pattern(randint(-9999999, 0)) == string
    `)
})
```

# --seed--

## --seed-contents--

```py

```

# --solutions--

```py
def number_pattern(n):
    result = "1"
    if isinstance(n, int):
        if n > 0:
            for i in range(2, n + 1):
                result += f" {i}"
            return result
        return "Argument must be an integer greater than 0."
    return "Argument must be an integer value."

```
