---
id: 66a37f37ef5823a313de8c26
title: Build a Moon Orbit
challengeType: 25
dashedName: build-a-moon-orbit
demoType: onClick
---

# --description--

In this lab, you will create a simple animation of the Moon's orbit around the Earth using HTML and CSS. The Earth will be at the center of the system, and the Moon will orbit around it.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should align all the elements to the center of the page by setting the height to `100%` of the viewport and setting a flexbox layout in the `body` element.
   
2. You should have a `div` with the class `space`.

3. Inside the `.space` element, there should be two more `div` elements with the class `earth` and `orbit`, respectively, in order.

4. Inside the `.orbit` element, there should be another `div` with the class `moon`.
   
5. The `div` element with a `class` of `space` should be centered on the page and have a width and height of `200px`.

6. The `div` element with a `class` of `space` should use `relative` positioning.

7. The `.earth` element should use `absolute` positioning. Position the center of the `.earth` element at the halfway point of its parent on both the vertical (top) and horizontal (left) axes. After that, shift the `.earth` element back by half its own width and height, to center it within its parent, the `.space` element.

8. The `.earth` element should have a width and height of `100px`.

9.  The `.orbit` element should have a width and height of `200px`.

10.  The `.orbit` element should be positioned using `absolute` positioning. Its bottom right corner should be at the center of the `.space` element using a `transform` property that shifts it by `-50%` on both the vertical and horizontal axes.

11. The orbit path for the moon around the Earth should be a circle.

12. The `.moon` element should be positioned using `absolute` positioning and have a width and height of `30px`. The `.moon` element should position itself at the top of the `.orbit` element and be centered horizontally.

13. You should further adjust the horizontal positioning of the `.moon` element by moving the element to the left by half of its width.

14. The `.earth` selector should have a background color and a `border-radius` of `50%`.

15. The `.moon` selector should have a background color and a `border-radius` of `50%`.

16. You should define a `@keyframes orbit` animation that rotates the `.orbit` element 360 degrees around its center. You should apply this animation to the `.orbit` element with a duration of `5` seconds, a linear timing function, and infinite iterations.

**Note:** Be sure to link your stylesheet in your HTML and apply your CSS.

# --hints--

The contents of the `body` element should be centered on the page by setting the height to `100%` of the viewport height, `display` to `flex`, `justify-content`, and `align-items` to `center`.

```js

assert.strictEqual(new __helpers.CSSHelp(document).getStyle('body')?.height, '100vh')
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('body')?.display, 'flex');
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('body')?.justifyContent, 'center');
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('body')?.alignItems, 'center');
```

You should have a main `div` with the class `space`.

```js
assert.strictEqual(document.querySelector('div')?.getAttribute('class'), 'space');
```

The `.space` element should have a width and height of `200px`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.space')?.width, '200px')
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.space')?.height, '200px');
```

The `.space` element should have a `position` property of `relative`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.space')?.position, 'relative')
```

You should have a `div` with a class of `earth` inside the `div` with a `class` of `space`.

```js
assert.exists(document.querySelector('div.space div.earth'));
```

The `.earth` element should be the first child of the `.space` element.

```js
assert.strictEqual(document.querySelector('.space > div')?.getAttribute('class'), 'earth');
```

The `.earth` element should have a width and height of `100px`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.width, '100px');
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.height, '100px');
```

The `.earth` element should use `absolute` positioning.


```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.position, 'absolute');
```

The `.earth` element should have a `top` and `left` position of `50%`.


```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.top, '50%') 
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.left, '50%');
```

The `.earth` element should be moved back and up by `50%` by setting the `transform` property to `translate(-50%, -50%)`.


```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.transform, 'translate(-50%, -50%)');
```

You should have a `div` with the class `orbit` inside the `.space` element.

```js
assert.exists(document.querySelector('div.space div.orbit'));
```

The `.orbit` element should come after the `.earth` element.

```js
assert.isTrue(document.querySelector('.earth')?.nextElementSibling?.classList?.contains('orbit'));
```

The `.orbit` element should have a width and height of `200px`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.orbit')?.width, '200px')
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.orbit')?.height, '200px');
```

The `.orbit` element should use `absolute` positioning.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.orbit')?.position, 'absolute');
```

The `.orbit` element should be positioned at the center of the `.space` element using a `transform` property that shifts it by `-50%` on both the vertical and horizontal axes.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.orbit')?.transform, 'translate(-50%, -50%)');
```

You should have a `div` with the class `moon` inside the `.orbit` element.

```js
assert.exists(document.querySelector('div.space div.orbit div.moon'));
```

The `.moon` element should have a width and height of `30px`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.width, '30px') 
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.height, '30px');
```

The `.moon` element should be positioned using `absolute` positioning.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.position, 'absolute');
```

The top edge of the `.moon` element should be aligned with the top edge of its containing block.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.top, '0px');
```

You should move the left edge of the `.moon` element to the center of the containing block (`50%` from the left side).

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.left, '50%');
```

The `.moon` element should be adjusted horizontally by translating it to `-50%` across the x-axis.

```js
const transformValue = new __helpers.CSSHelp(document).getStyle('.moon')?.transform;
const validTransforms = ['translateX(-50%)', 'translate(-50%)'];
assert.oneOf(transformValue, validTransforms);
```

The `.earth` selector should have a background color.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('.earth')?.backgroundColor);
```

The `.earth` selector should have `border-radius` of `50%`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.earth')?.borderRadius, '50%');
```

The `.moon` selector should have a background color.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('.moon')?.backgroundColor);
```

The `.moon` selector should have `border-radius` of `50%`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('.moon')?.borderRadius, '50%');
```

You should have a `@keyframes` rule.

```js
assert.lengthOf(new __helpers.CSSHelp(document).getCSSRules('keyframes'), 1);
```

Your new `@keyframes` rule should be named `orbit`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.name, 'orbit');
```

Your `@keyframes orbit` rule should have a `0%` selector.

```js
const rules = new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.cssRules; 
assert.strictEqual(rules?.[0]?.keyText, '0%');
```

Your `@keyframes orbit` rule should have a `100%` selector.

```js 
const rules = new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.cssRules
assert.isTrue(rules?.[0]?.keyText === '100%' || rules?.[1]?.keyText === '100%');
```

Your `0%` selector should have a `transform` property set to `rotate(0deg) translate(-50%, -50%)`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.cssRules?.[0]?.style?.transform, 'rotate(0deg) translate(-50%, -50%)');
```

Your `100%` selector should come after your `0%` selector.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.cssRules?.[1]?.keyText, '100%')
```

Your `100%` selector should have a `transform` property set to `rotate(360deg) translate(-50%, -50%)`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getCSSRules('keyframes')?.[0]?.cssRules?.[1]?.style?.transform, 'rotate(360deg) translate(-50%, -50%)')
```

Your `.orbit` selector should have an `animation` property set to `orbit 5s linear infinite`.

```js

const orbitStyles = new __helpers.CSSHelp(document).getStyle('.orbit');
assert.strictEqual(orbitStyles?.animationName, "orbit");
assert.strictEqual(orbitStyles?.animationDuration, "5s");
assert.strictEqual(orbitStyles?.animationTimingFunction, "linear");
assert.strictEqual(orbitStyles?.animationIterationCount, "infinite");

```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Moon Orbit</title>
</head>

<body>

</body>

</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Moon Orbiting Earth</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="space">
        <div class="earth"></div>
        <div class="orbit">
            <div class="moon"></div>
        </div>
    </div>
</body>

</html>
```

```css
body {
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    margin: 0;
    background-color: #000;
}

.space {
    position: relative;
    width: 200px;
    height: 200px;
}

.earth {
    width: 100px;
    height: 100px;
    background-color: blue;
    border-radius: 50%;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    box-shadow: 0 0 20px rgba(0, 0, 255, 0.5);
}

.orbit {
    width: 200px;
    height: 200px;
    position: absolute;
    transform: translate(-50%, -50%);
    animation: orbit 5s linear infinite;
}

.moon {
    width: 30px;
    height: 30px;
    background-color: gray;
    border-radius: 50%;
    position: absolute;
    top: 0;
    left: 50%;
    transform: translateX(-50%);
    box-shadow: 0 0 10px rgb(255, 255, 255);
}


@keyframes orbit {
    0% {
        transform: rotate(0deg) translate(-50%, -50%);
    }

    100% {
        transform: rotate(360deg) translate(-50%, -50%);
    }
}
```

