---
id: 66c06fad3475cd92421b9ac2
title: Build a Leap Year Calculator
challengeType: 26
dashedName: build-a-leap-year-calculator
---

# --description--

A leap year is a year that is divisible by `4`, except for years that are divisible by `100` and not divisible by `400`. For example, `2000` is a leap year, but `1900` is not. Also, a leap year has an extra day in February, which is the 29th day of the month.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. Define a function called `isLeapYear` that takes a number as an argument.
2. Outside the function, declare a variable `year` that stores the value of the year you want to check.
3. Inside the function, use an `if/ else` statement or a ternary operator to check if the year is a leap year.
4. To check if the year is a leap year, fulfill the following conditions:

   - If the year is divisible by `4`, then it is a leap year.
   - Unless the year is also divisible by `100`, then it is not a leap year.
   - Unless the year is also divisible by `400`, then it is a leap year.

5. If the year is a leap year, return `[year] is a leap year.`. Otherwise, return `[year] is not a leap year.`. You will replace `[year]` with the parameter defined in the `isLeapYear` function.
6. You should call the `isLeapYear` function with `year` as the argument and assign the result to a variable named `result`.
7. You should output the `result` variable to the console using `console.log()`.

# --hints--

You should define a function named `isLeapYear`.

```js
assert.isFunction(isLeapYear);
```

The `isLeapYear` function should take a number as an argument.

```js
assert.match(isLeapYear.toString(), /\s*isLeapYear\(\s*\w+\s*\)/);
```

You should declare a variable `year` and assign it a value to check if it is a leap year.

```js
assert.isDefined(year);
```

The `year` variable shouldn't be empty.

```js
assert.isNotNull(year);
```

With `2024` as the value of the `year` variable, the `result` should be `2024 is a leap year.`.

```js
assert.strictEqual(isLeapYear(2024), '2024 is a leap year.');
```

With `2000` as the value of the `year` variable, the `result` should be `2000 is a leap year.`.

```js
assert.strictEqual(isLeapYear(2000), '2000 is a leap year.');
```

With `1900` as the value of the `year` variable, the `result` should be `1900 is not a leap year.`.

```js
assert.strictEqual(isLeapYear(1900), '1900 is not a leap year.');

```

You should call the `isLeapYear` function and pass `year` as a parameter.

```js
assert.match(__helpers.removeJSComments(code), /isLeapYear\(\s*year\s*\)/);
```

You should declare a `result` variable.

```js
assert.isDefined(result);
```

You should store the result of calling the `isLeapYear` function in a variable named `result`.

```js
assert.match(__helpers.removeJSComments(code), /result\s*=\s*isLeapYear\(\s*year\s*\)/);
```

You should output the `result` to the console using `console.log()`.

```js
assert.match(__helpers.removeJSComments(code), /console\.log\(\s*result\s*\)/);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function isLeapYear(year) {
  if ((year % 4 === 0 && year % 100 !== 0) || year % 400 === 0) {
    return(year + " is a leap year.");
  } else {
    return(year + " is not a leap year.");
  }
}

const year = 2024;
const result = isLeapYear(year);
console.log(result);
```

