---
id: 66ed41f912d0bb1dc62da5dd
title: Build a JavaScript Trivia Bot
challengeType: 26
dashedName: lab-javascript-trivia-bot
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should log `"Hello! I'm your coding fun fact guide!"` to the console as a greeting message to the user.
1. You should create three variables: `botName`, `botLocation`, and `favoriteLanguage`, that store the bot's name, where it's from, and its favorite coding language, respectively.
1. You should log `"My name is (botName) and I live on (botLocation)."` to the console.
1. You should log `"My favorite programming language is (favoriteLanguage)."` to the console.
1. You should use `let` to create a `codingFact` variable and assign it a string that is a fun fact about your bot's favorite coding language and include the use of the `favoriteLanguage` variable.
1. You should log the `codingFact` to the console.
1. You should reassign the `codingFact` variable to a new fact about the bot's favorite language using the `favoriteLanguage` variable again.
1. You should log the `codingFact` to the console again.
1. You should reassign the `codingFact` variable again to another new fact about the bot's favorite language using the `favoriteLanguage` variable.
1. You should log the `codingFact` to the console a third time.
1. You should log `"It was fun sharing these facts with you. Goodbye! - (botName) from (botLocation)."` to the console as a farewell statement from the bot.

# --before-each--

```js
const spy = __helpers.spyOn(console, 'log');
const getLogs = () => spy.calls.map(call => call?.[0]);
```

# --hints--

You should log `"Hello! I'm your coding fun fact guide!"` to the console.

```js
assert.equal(getLogs()[0], "Hello! I'm your coding fun fact guide!")
```

You should declare a `botName` variable. Double check for any spelling or casing errors.

```js
assert.exists(botName);
```

Your `botName` variable should be a string.

```js
assert.isString(botName);
```

You should declare a `botLocation` variable. Double check for any spelling or casing errors.

```js
assert.exists(botLocation);
```

Your `botLocation` variable should be a string.

```js
assert.isString(botLocation);
```

You should declare a `favoriteLanguage` variable. Double check for any spelling or casing errors.

```js
assert.exists(favoriteLanguage);
```

Your `favoriteLanguage` variable should be a string.

```js
assert.isString(favoriteLanguage);
```

You should log to the console `"My name is (botName) and I live on (botLocation)."` and add the variables to the string.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
assert.equal(getLogs()[1], `My name is ${botName} and I live on ${botLocation}.`)
```

You should log to the console `"My favorite programming language is (favoriteLanguage)."` and add the variable to the string.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
assert.equal(getLogs()[2], `My favorite programming language is ${favoriteLanguage}.`)
```

You should use `let` to declare a new variable `codingFact`.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
assert.match(code, /let\s+codingFact/)
```

You should give `codingFact` a value that includes `favoriteLanguage`.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
assert.match(code, /let\s+codingFact/);
assert.match(code, /codingFact\s*=\s*(("|'|`)?.+?\1?\s*\+?\s*|favoriteLanguage\s*\+\s*(("|'|`)?.+?\3?))/);
assert.exists(codingFact);
assert.isNotEmpty(codingFact);
assert.include(String(codingFact), favoriteLanguage);
assert.include(getLogs()[3], favoriteLanguage);
```

You should log `codingFact` to the console.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
const loggingCodingFacts = codeWithoutComments.match(/console\.log\(\s*codingFact\s*\)/g)
assert.include(getLogs()[3], favoriteLanguage);
assert.isAtLeast(loggingCodingFacts.length, 1);
```

You should assign a new value to `codingFact` that also contains `favoriteLanguage`, and log it to the console.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
const loggingCodingFacts = codeWithoutComments.match(/console\.log\(\s*codingFact\s*\)/g)
const [first, second, third] = codeWithoutComments.match(/(let )?\s*codingFact\s*=\s*(("|')?.+?\2?\s*\+?\s*|favoriteLanguage\s*\+\s*(("|')?.+?\2?))/g);
assert.include(getLogs()[4], favoriteLanguage);
assert.notEqual(getLogs()[4], getLogs()[3]);
assert.isAtLeast(loggingCodingFacts.length, 2);
assert.exists(second);
assert.isNotEmpty(codingFact); 
```

You should assign a value to `codingFact` for the third time that also contains `favoriteLanguage`, and log it to the console.

```js
const codeWithoutComments = __helpers.removeJSComments(code);
const loggingCodingFacts = codeWithoutComments.match(/console\.log\(\s*codingFact\s*\)/g)
assert.include(getLogs()[5], favoriteLanguage);
assert.notEqual(getLogs()[5], getLogs()[4]);
assert.equal(getLogs()[5], codingFact);
assert.lengthOf(loggingCodingFacts, 3);
assert.isNotEmpty(codingFact); 
```

You should log to the console `"It was fun sharing these facts with you. Goodbye! - (botName) from (botLocation)."` and add the values of the variables.

```js
assert.equal(getLogs()[6], `It was fun sharing these facts with you. Goodbye! - ${botName} from ${botLocation}.`);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
console.log("Hello! I'm your coding fun fact guide!");

const botName = "JsBot";
const botLocation = "planet Eris";
const favoriteLanguage = "JavaScript";

console.log("My name is " + botName + " and I live on " + botLocation + ".");
console.log("My favorite programming language is " + favoriteLanguage + ".");

let codingFact = "Did you know that " + favoriteLanguage + " was created in just 10 days?";

console.log(codingFact);

codingFact = "Another fun fact: " + favoriteLanguage + "was originally called Mocha!";

console.log(codingFact);

codingFact = "Also, " + favoriteLanguage + " is the most popular programming language in the world.";

console.log(codingFact);

console.log("It was fun sharing these facts with you. Goodbye! - " + botName + " from " + botLocation + ".");

```
