---
id: 66d6a7a3e1aa411e94bf2346
title: Build a House Painting
challengeType: 25
dashedName: build-a-house-painting
demoType: onClick
---

# --description--

In this lab, you will use HTML to create the structure of a house. Then, you will use CSS positioning to arrange the elements of your house like windows and doors.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `div` with an `id` of `house`.
1. Your `#house` should have a `position` set to `relative` so its children can be positioned with respect to it.
1. Your `#house` should have a width of `500px` and a height of `400px`. Do not set minimum or maximum values.
1. Your `#house` should have a background color and a border set.
1. You should have five `div` elements inside `#house` with the following `id` values: `chimney`, `roof`, `window-1`, `window-2`, and `door`.
1. All of the immediate children of the `#house` should have a `position` of `absolute`.
1. `#roof`, `#chimney`, `#window-1`, `#window-2`, and `#door` should have a width, height, border, and background color set.
1. Your `#roof` should have a top value of `0`.
1. Your `#door` should be placed at the bottom of your house.
1. Your windows should be placed below your `#roof` and at least higher than one third of your `#door`'s height.
1. Both your windows and your door should have either `left` or `right` set to a value that places them within the house borders.
1. Your `#chimney` should have a top value that puts it at the top of your `#house`.
1. Your `#chimney` should have a `z-index` that puts it behind the house.

**Note:** Be sure to link your stylesheet in your HTML to apply your CSS.

# --hints--

You should have a `div` with an `id` of `house`.

```js
assert.exists(document.querySelector("div#house"));
```

You should target `#house` and set its `position` to `relative`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#house')?.getPropertyValue("position"), "relative");
```

You should target `#house` and set its `border` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("border"));
```

You should target `#house` and set its `background-color` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("background-color"));
```

`#house` should not contain a `min-height` property.

```js
assert.isEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("min-height"));
```

`#house` should not contain a `min-width` property.

```js
assert.isEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("min-width"));
```

`#house` should not contain a `max-height` property.

```js
assert.isEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("max-height"));
```

`#house` should not contain a `max-width` property.

```js
assert.isEmpty(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("max-width"));
```

You should target `#house` and set its width to `500px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle("#house")?.getPropertyValue("width"), "500px")
```

You should target `#house` and set its height to `400px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#house')?.getPropertyValue("height"), "400px")
```

You should have a `div` with an `id` of `chimney` within the `#house`.

```js
assert.exists(document.querySelector("div#house div#chimney"));
```

`#chimney` should have the `position` property set to `absolute`.

```js
assert.equal(getComputedStyle(document.querySelector("#chimney"))?.getPropertyValue("position"), "absolute");
```

You should target `#chimney` and set its `width` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#chimney")?.getPropertyValue("width"));
```

You should target `#chimney` and set its `height` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#chimney")?.getPropertyValue("height"));
```

You should target `#chimney` and set its `border` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#chimney")?.getPropertyValue("border"));
```

You should target `#chimney` and set its `background-color` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#chimney")?.getPropertyValue("background-color"));
```

You should have a `div` with an `id` of `roof` within the `#house`.

```js
assert.exists(document.querySelector("div#house  div#roof"));
```

`#roof` should have the `position` property set to `absolute`.

```js
assert.equal(getComputedStyle(document.querySelector("#roof"))?.getPropertyValue("position"), "absolute");
```

You should target `#roof` and set its `width` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#roof")?.getPropertyValue("width"));
```

You should target `#roof` and set its `height` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#roof")?.getPropertyValue("height"));
```

You should target `#roof` and set its `border` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#roof")?.getPropertyValue("border"));
```

You should target `#roof` and set its `background-color` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#roof")?.getPropertyValue("background-color"));
```

You should have a `div` with an `id` of `window-1` within the `#house`.

```js
assert.exists(document.querySelector("div#house  div#window-1"));
```

`#window-1` should have the `position` property set to `absolute`.

```js
assert.equal(getComputedStyle(document.querySelector("#window-1"))?.getPropertyValue("position"), "absolute");
```

You should target `#window-1` and set its `width` property.

```js
const window1 = new __helpers.CSSHelp(document).getStyle("#window-1")?.getPropertyValue("width");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("width") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("width");
assert.isNotEmpty(window1 || windows);
```

You should target `#window-1` and set its `height` property.

```js
const window1 = new __helpers.CSSHelp(document).getStyle("#window-1")?.getPropertyValue("height");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("height") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("height");
assert.isNotEmpty(window1 || windows);
```

You should target `#window-1` and set its `border` property.

```js
const window1 = new __helpers.CSSHelp(document).getStyle("#window-1")?.getPropertyValue("border");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("border") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("border");
assert.isNotEmpty(window1 || windows);
```

You should target `#window-1` and set its `background-color` property.

```js
const window1 = new __helpers.CSSHelp(document).getStyle("#window-1")?.getPropertyValue("background-color");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("background-color") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("background-color");
assert.isNotEmpty(window1 || windows);
```

You should have a `div` with an `id` of `window-2` within the `#house`.

```js
assert.exists(document.querySelector("div#house  div#window-2"));
```

`#window-2` should have the `position` property set to `absolute`.

```js
assert.equal(getComputedStyle(document.querySelector("#window-2"))?.getPropertyValue("position"), "absolute");
```

You should target `#window-2` and set its `width` property.

```js
const window2 = new __helpers.CSSHelp(document).getStyle("#window-2")?.getPropertyValue("width");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("width") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("width");
assert.isNotEmpty(window2 || windows);
```

You should target `#window-2` and set its `height` property.

```js
const window2 = new __helpers.CSSHelp(document).getStyle("#window-2")?.getPropertyValue("height");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("height") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("height");
assert.isNotEmpty(window2 || windows);
```

You should target `#window-2` and set its `border` property.

```js
const window2 = new __helpers.CSSHelp(document).getStyle("#window-2")?.getPropertyValue("border");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("border") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("border");
assert.isNotEmpty(window2 || windows);
```

You should target `#window-2` and set its `background-color` property.

```js
const window2 = new __helpers.CSSHelp(document).getStyle("#window-2")?.getPropertyValue("background-color");
const windows = new __helpers.CSSHelp(document).getStyle("#window-1, #window-2")?.getPropertyValue("background-color") || new __helpers.CSSHelp(document).getStyle("#window-2, #window-1")?.getPropertyValue("background-color");
assert.isNotEmpty(window2 || windows);
```

You should have a `div` with an `id` of `door` within the `#house`.

```js
assert.exists(document.querySelector("div#house  div#door"));
```

`#door` should have the `position` property set to `absolute`.

```js
assert.equal(getComputedStyle(document.querySelector("#door"))?.getPropertyValue("position"), "absolute");
```

You should target `#door` and set its `width` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#door")?.getPropertyValue("width"));
```

You should target `#door` and set its `height` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#door")?.getPropertyValue("height"));
```

You should target `#door` and set its `border` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#door")?.getPropertyValue("border"));
```

You should target `#door` and set its `background-color` property.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle("#door")?.getPropertyValue("background-color"));
```

Your `#roof` should have the `top` property set to `0`.

```js
assert.equal(getComputedStyle(document.querySelector("#roof"))?.getPropertyValue("top"), "0px");
```

Your `#door` should be placed at the bottom of the house.

```js
const door = getComputedStyle(document.querySelector("#door"))
const doorBottom = Number(door.getPropertyValue("bottom").replace("px", ""));
assert.strictEqual(doorBottom, 0);
```

You should set either `left` or `right` on your `#door` and arrange it within the house borders.

```js
const door = getComputedStyle(document.querySelector("#door"))
const doorLeft = Number(door.getPropertyValue("left").replace("px", ""));
const doorRight = Number(door.getPropertyValue("right").replace("px", ""));
assert.isAbove(doorLeft, 0);
assert.isAbove(doorRight, 0);
```

Your `#chimney` should have a `top` value that puts it at the top of your `#house`.

```js
const chimney = getComputedStyle(document.querySelector("#chimney"));
assert.approximately(parseFloat(chimney?.getPropertyValue("top")), - parseFloat(chimney?.getPropertyValue("height")), 2);
```

Your `#chimney` should have a `z-index` that puts it behind the house.

```js
const houseZIndex = getComputedStyle(document.querySelector("#house"))?.getPropertyValue("z-index");
const chimneyZIndex = getComputedStyle(document.querySelector("#chimney"))?.getPropertyValue("z-index");
if (houseZIndex === "auto") {
    assert.isBelow(Number(chimneyZIndex), 0)
} else {
    assert.isBelow(Number(chimneyZIndex), Number(houseZIndex));
}
```

Your windows should be placed below your `#roof` and at least higher than one third of your `#door`'s height.

```js
const window1 = getComputedStyle(document.querySelector("#window-1"))
const window2 = getComputedStyle(document.querySelector("#window-2"))
const door = getComputedStyle(document.querySelector("#door"))
const roof = getComputedStyle(document.querySelector("#roof"))
const w1Top = Number(window1.getPropertyValue("top").replace("px", ""));
const w1Bottom = Number(window1.getPropertyValue("bottom").replace("px", ""));
const w2Top = Number(window2.getPropertyValue("top").replace("px", ""));
const w2Bottom = Number(window2.getPropertyValue("bottom").replace("px", ""));
const doorHeight = Number(door.getPropertyValue("height").replace("px", ""));
const roofHeight = Number(roof.getPropertyValue("height").replace("px", ""));
assert.isAbove(w1Top, roofHeight);
assert.isAbove(w1Bottom, doorHeight/3);
assert.isAbove(w2Top, roofHeight);
assert.isAbove(w2Bottom, doorHeight/3);
```

You should set either `left` or `right` on your windows and arrange them within the house borders.

```js
const window1 = getComputedStyle(document.querySelector("#window-1"))
const window2 = getComputedStyle(document.querySelector("#window-2"))
const w1Left = Number(window1.getPropertyValue("left").replace("px", ""));
const w1Right = Number(window1.getPropertyValue("right").replace("px", ""));
const w2Left = Number(window2.getPropertyValue("left").replace("px", ""));
const w2Right = Number(window2.getPropertyValue("right").replace("px", ""));
assert.isAbove(w1Left, 0);
assert.isAbove(w1Right, 0);
assert.isAbove(w2Left, 0);
assert.isAbove(w2Right, 0);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>House Painting</title>
</head>
<body>

</body>
</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>House Painting</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div id="house">
        <div id="chimney">
          <div id="smoke"></div>
        </div>
        <div id="roof"></div>
        <div id="window-1"></div>
        <div id="window-2"></div>
        <div id="door">
          <div id="door-knob"></div>
        </div>
        <div id="welcome">WELCOME</div>
    </div>
</body>
</html>
```

```css
* {
    box-sizing: border-box;
  }

  body {
    margin: 0;
    padding: 0;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background: linear-gradient(
      #b3e6ff,
      #b3e6ff 60%,
      green 60%
    );
  }

  #house {
    flex: 0 0 auto;
    width: 500px;
    height: 400px;
    position: relative;
    background-color: #ff9980;
    border: 6px solid #b35900;
  }

  #chimney {
    position: absolute;
    width: 90px;
    height: 100px;
    top: -100px;
    left: 65%;
    background: repeating-linear-gradient(
      #e6e6e6,
      #e6e6e6 10%,
      black 10%,
      black 12%
    );
    border: 2px solid black;
    z-index: -1;
  }

  #smoke {
    width: 40px;
    height: 40px;
    background-color: rgba(0,0,0,0.3);
    position: absolute;
    top: -20px;
    left: 20px;
    border-radius: 50%;
    box-shadow: 0 -10px 10px 10px rgba(0,0,0,0.3);
    border: none;
  }

  #roof {
    border: 2px;
    width: 100%;
    height: 110px;
    background-color: green;
    position: absolute;
    top: 0;
    background: repeating-linear-gradient(
      45deg,
      #b35900,
      #b35900 2%,
      transparent 2%,
      transparent 5%
    ), repeating-linear-gradient(
      -45deg,
      #b35900,
      #b35900 2%,
      #ff9980 2%,
      #ff9980 5%
    )
  }

  #window-1, #window-2 {
    width: 100px;
    height: 100px;
    background: linear-gradient(
      to right,
      #ffffb3,
      #ffffb3 48%,
      #b35900 48%,
      #b35900 52%,
      #ffffb3 52%,
      #ffffb3 100%
    );
    position: absolute;
    top: 40%;
    border: 6px solid #b35900;
  }

  #window-1 {
    left: 7.5%;
  }

  #window-2 {
    right: 7.5%;
  }

  #door {
    width: 130px;
    height: 180px;
    position: absolute;
    bottom: 0%;
    left: 185px;
    background-color: #e6e6e6;
    border: 6px solid #b35900;
    transform: translateY(6px);
  }

  #door-knob {
    width: 20px;
    height: 20px;
    background-color: #b35900;
    border-radius: 50%;
    position: absolute;
    top: 50%;
    right: 5%;
  }

  #welcome {
    font-family: sans-serif;
    font-weight: bold;
    width: 130px;
    height: 40px;
    position: absolute;
    bottom: -47px;
    left: 178px;
    background-color: #85e085;
    border: 2px solid black;
    transform: skewX(-20deg);
    display: flex;
    align-items: center;
    justify-content: center;
  }
```
