---
id: 66bb6a9c2dd58b73cd759034
title: Build a Gradebook App
challengeType: 26
dashedName: build-a-gradebook-app
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a function named `getAverage` that takes an array of test scores as a parameter and returns the average score.
1. You should have a function named `getGrade` that takes a student score as a parameter and returns a string representing a letter grade based on the score. Here are the scores and their corresponding letter grades:

    | Score Range | Grade   |
    | ----------- | ------- |
    | `100`       | `"A+"`  |
    | `90 - 99`   | `"A"`   |
    | `80 - 89`   | `"B"`   |
    | `70 - 79`   | `"C"`   |
    | `60 - 69`   | `"D"`   |
    | `0 - 59`    | `"F"`   |

1. You should have a function named `hasPassingGrade` that takes a score as a parameter and returns either `true` or `false` depending on if the score corresponds to a passing grade.
1. The `hasPassingGrade` function should use the `getGrade` function to get the letter grade, and use it to determine if the grade is passing. A passing grade is anything different from `"F"`.
1. You should have a function named `studentMsg` that takes an array of scores and a student score as the parameters. The function should return a string with the format:

    - `"Class average: average-goes-here. Your grade: grade-goes-here. You passed the course."`, if the student passed the course.
    - `"Class average: average-goes-here. Your grade: grade-goes-here. You failed the course."`, if the student failed the course.

    Replace `average-goes-here` with the average of total scores and `grade-goes-here` with the student's grade.
    Use `getAverage` to get the average score and `getGrade` to get the student's grade.

# --hints--

You should have a function named `getAverage`.

```js
assert.isFunction(getAverage);
```

Your `getAverage` function should return a number.

```js
assert.isNumber(getAverage([92, 88, 12, 77, 57, 100, 67, 38, 97, 89]));
```

`getAverage([92, 88, 12, 77, 57, 100, 67, 38, 97, 89])` should return `71.7`.

```js
assert.strictEqual(getAverage([92, 88, 12, 77, 57, 100, 67, 38, 97, 89]), 71.7);
```

`getAverage([45, 87, 98, 100, 86, 94, 67, 88, 94, 95])` should return `85.4`.

```js
assert.strictEqual(getAverage([45, 87, 98, 100, 86, 94, 67, 88, 94, 95]), 85.4);
```

`getAverage([38, 99, 87, 100, 100, 100, 100, 100, 100, 100])` should return `92.4`.

```js
assert.strictEqual(getAverage([38, 99, 87, 100, 100, 100, 100, 100, 100, 100]), 92.4);
```

`getAverage([10, 20, 30, 40, 55, 65, 75, 83])` should return `47.25`.

```js
assert.strictEqual(getAverage([10, 20, 30, 40, 55, 65, 75, 83]), 47.25);
```

`getAverage([10, 20, 30, 40, 50, 60, 70, 97])` should return `47.125`.

```js
assert.strictEqual(getAverage([10, 20, 30, 40, 50, 60, 70, 97]), 47.125);
```

Your `getAverage` function should return the average score of the test scores.

```js
assert.strictEqual(getAverage([52, 56, 60, 65, 70, 75, 80, 85, 90, 95]), 72.8);
assert.strictEqual(getAverage([45, 50, 55, 60, 65, 70, 75, 80, 85, 90]), 67.5);
assert.strictEqual(getAverage([38, 42, 46, 50, 54, 58, 62, 66, 70, 74]), 56);
```

You should have a function named `getGrade`.

```js
assert.isFunction(getGrade);
```

Your `getGrade` function should return `"A+"` if the score is `100`.

```js
assert.strictEqual(getGrade(100), "A+");
```

Your `getGrade` function should return `"A"` if the score is between `90` and `99`.

```js
assert.strictEqual(getGrade(90), "A");
assert.strictEqual(getGrade(94), "A");
assert.strictEqual(getGrade(99), "A");
```

Your `getGrade` function should return `"B"` if the score is between `80` and `89`.

```js
assert.strictEqual(getGrade(80), "B");
assert.strictEqual(getGrade(83), "B");
assert.strictEqual(getGrade(88), "B");
```

Your `getGrade` function should return `"C"` if the score is between `70` and `79`.

```js
assert.strictEqual(getGrade(70), "C");
assert.strictEqual(getGrade(75), "C");
assert.strictEqual(getGrade(79), "C");
```

Your `getGrade` function should return `"D"` if the score is between `60` and `69`.

```js
assert.strictEqual(getGrade(60), "D");
assert.strictEqual(getGrade(63), "D");
assert.strictEqual(getGrade(68), "D");
```

Your `getGrade` function should return `"F"` if the score is between `0` and `59`.

```js
assert.strictEqual(getGrade(0), "F");
assert.strictEqual(getGrade(30), "F");
assert.strictEqual(getGrade(43), "F");
assert.strictEqual(getGrade(59), "F");
```


You should have a function named `hasPassingGrade`.

```js
assert.isFunction(hasPassingGrade);
```

Your `hasPassingGrade` function should return a boolean value.

```js
assert.isBoolean(hasPassingGrade(100));
```

Your `hasPassingGrade` function should return `true` if the grade is an `"A"`.

```js
assert.isTrue(hasPassingGrade(100));
```

Your `hasPassingGrade` function should return `false` if the grade is an `"F"`.

```js
assert.isFalse(hasPassingGrade(53));
```

Your `hasPassingGrade` function should return `true` for all passing grades.

```js
assert.isTrue(hasPassingGrade(87));
assert.isTrue(hasPassingGrade(60));
assert.isTrue(hasPassingGrade(73));
assert.isTrue(hasPassingGrade(96));
```

You should have a function named `studentMsg`.

```js
assert.isFunction(studentMsg);
```

`studentMsg([92, 88, 12, 77, 57, 100, 67, 38, 97, 89], 37)` should return the following message: `"Class average: 71.7. Your grade: F. You failed the course."`.

```js
assert.strictEqual(studentMsg([92, 88, 12, 77, 57, 100, 67, 38, 97, 89], 37), "Class average: 71.7. Your grade: F. You failed the course.");
```

`studentMsg([56, 23, 89, 42, 75, 11, 68, 34, 91, 19], 100)` should return the following message: `"Class average: 50.8. Your grade: A+. You passed the course."`.

```js
assert.strictEqual(studentMsg([56, 23, 89, 42, 75, 11, 68, 34, 91, 19], 100), "Class average: 50.8. Your grade: A+. You passed the course.");
```

`studentMsg([12, 22, 32, 42, 52, 62, 72, 92], 85)` should return the following message: `"Class average: 48.25. Your grade: B. You passed the course."`.

```js
assert.strictEqual(studentMsg([12, 22, 32, 42, 52, 62, 72, 92], 85), "Class average: 48.25. Your grade: B. You passed the course.");
```

`studentMsg([15, 25, 35, 45, 55, 60, 70, 60], 75)` should return the following message: `"Class average: 45.625. Your grade: C. You passed the course."`.

```js
assert.strictEqual(studentMsg([15, 25, 35, 45, 55, 60, 70, 60], 75), "Class average: 45.625. Your grade: C. You passed the course.");
```

Your `studentMsg` function should return the correct message based on the student's score and the class average.

```js
assert.strictEqual(studentMsg([33, 44, 55, 66, 77, 88, 99, 100], 92), "Class average: 70.25. Your grade: A. You passed the course.");
assert.strictEqual(studentMsg([33, 44, 55, 66, 77, 88, 99, 100], 57), "Class average: 70.25. Your grade: F. You failed the course.");
```


# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function getAverage(scores) {
    let sum = 0;

    for (const score of scores) {
      sum += score;
    }

    return sum / scores.length;
  }

  function getGrade(score) {
    if (score === 100) {
      return "A+";
    } else if (score >= 90) {
      return "A";
    } else if (score >= 80) {
      return "B";
    } else if (score >= 70) {
      return "C";
    } else if (score >= 60) {
      return "D";
    } else {
      return "F";
    }
  }

  function hasPassingGrade(score) {
    return getGrade(score) !== "F";
  }

  function studentMsg(totalScores, studentScore) {
    let average = getAverage(totalScores);
    let grade = getGrade(studentScore);

    return `Class average: ${average}. Your grade: ${grade}. You ${
      hasPassingGrade(studentScore) ? "passed" : "failed"
    } the course.`;
  }
```
