---
id: 66c07238b01053abaf812065
title: Build a Factorial Calculator
challengeType: 26
dashedName: build-a-factorial-calculator
---

# --description--

A factorial is the product of an integer and all the integers below it. For example, the factorial of `5` is `5 * 4 * 3 * 2 * 1 = 120`. In this lab, you will create a factorial calculator that takes a number from the user and calculates the factorial of that number.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should declare a variable `num` and assign it a number of your choice. The assigned number should be between `1` and `20` inclusive.
1. Create a function named `factorialCalculator` that takes a number as an argument and returns the factorial of that number.
1. Inside the function, declare a `result` variable and assign it the value of `1`. Using a loop, loop through all numbers from `1` to the input number(inclusive) and for each number, multiply the `result` variable by the current number and assign the result to the `result` variable. You can choose to use  either a `for` loop, `while` loop or `do...while` loop here.
1. You should call the `factorialCalculator` function with `num` as the argument and assign the result to the variable `factorial`.
1. You should store the final output in the format `Factorial of [num] is [factorial]` and assign it to the variable `resultMsg`.
1. You should output the value of `resultMsg` to the console.

# --hints--

You should have a `num` variable.

```js
assert.isDefined(num);
```

You should assign a value to the `num` variable

```js
assert.isNotNull(num);
```

The value of `num` should be between `1` and `20`.

```js
assert.isAtLeast(num, 1);
assert.isAtMost(num, 20);
```

The `num` value should be a number.

```js
assert.isNumber(num);
```

You should have a function named `factorialCalculator`.

```js
assert.isFunction(factorialCalculator);
```

The `factorialCalculator` function should take a number as an argument.

```js
assert.match(factorialCalculator.toString(), /\s*factorialCalculator\(\s*\w+\s*\)/);
```

The factorial of `5` should return `120`.

```js
assert.strictEqual(factorialCalculator(5), 120);
```

The factorial of `7` should return `5040`.

```js
assert.strictEqual(factorialCalculator(7), 5040);
```

You should call your `factorialCalculator` function with the `num` variable as the argument.

```js
assert.match(__helpers.removeJSComments(code), /factorialCalculator\(\s*num\s*\)\s*;?\s*$/m);
```

You should define a `factorial` variable and assign the result of the `factorialCalculator` function to it.

```js
assert.isDefined(factorial);
assert.strictEqual(factorial, factorialCalculator(num));
```

Your `factorialCalculator` should produce the correct result.

```js
assert.strictEqual(factorialCalculator(6), 720);
assert.strictEqual(factorialCalculator(9), 362880);
assert.strictEqual(factorialCalculator(11), 39916800);
```

Your `resultMsg` should contain a string in a format `Factorial of [num] is [factorial]`.

```js
assert.strictEqual(resultMsg, `Factorial of ${num} is ${factorialCalculator(num)}`);
assert.notMatch(__helpers.removeJSComments(code), /Factorial of \d{1,2} is \d+/);
```

You should output the value of `resultMsg` to the console.

```js
assert.match(__helpers.removeJSComments(code), /console\.log\(resultMsg\)\s*;?\s?$/m);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
const num = 5;

function factorialCalculator(n) {
  let result = 1;

  for (let i = 2; i <= n; i++) {
    result *= i;
  }

  return result;
}

const factorial = factorialCalculator(num);
const resultMsg = `Factorial of ${num} is ${factorial}`;
console.log(resultMsg);
```
