---
id: 66e45c8140f9fda5c105ae26
title: Build an Event Flyer Page
challengeType: 25
dashedName: build-an-event-flyer-page
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `header` element within the body.
1. Your `header` element should have an image in it for your event, and an `h1` in it with your event title, in that order. You can use this image if you would like: `https://cdn.freecodecamp.org/curriculum/labs/event.jpg`
1. You should have a `main` element within the body.
1. Your `main` element should have at least two `section` elements within it showcasing the event features.
1. Your `section` elements each should have an `h2` within them.
1. Your body should have a top and bottom padding of `50px`.
1. Your body should have a top and bottom margin of `0`, and a left and right margin that centers itself.
1. Your body should have a width set relative to the width of the viewport.
1. Your body should use the `calc` function to set its `min-height` property to 100% of the viewport's height minus all padding applied to the top and bottom of the body.
1. You should have at least one `hr` within your flyer.
1. You should set the `width` of all `hr` and `section` elements to a percent value relative to its parent.

**Note:** Be sure to link your stylesheet in your HTML and apply your CSS.

# --hints--

You should have a `header` element within the `body` element.

```js
assert.exists(document.querySelector('body > header'));
```

You should have an `img` element as the first child in the `header`.

```js
assert.equal(document.querySelector('header')?.children?.[0].tagName, 'IMG');
```

You should have an `h1` element as the second child in the `header`.

```js
assert.equal(document.querySelector('header')?.children?.[1].tagName, 'H1');
```

You should only have one `h1` element.

```js
assert.lengthOf(document.querySelectorAll('h1'), 1);
```

Your `h1` should have the title of your event.

```js
assert.isAtLeast(document.querySelector('h1').innerText.length, 1);
```

You should have a `main` element within the `body` element.

```js
assert.exists(document.querySelector('body > main'));
```

You should have at least two `section` elements within your `main` element.

```js
assert.isAtLeast(document.querySelectorAll('main > section').length, 2);
```

Your `section` elements should each have an `h2` within them.

```js
const sections = document.querySelectorAll('main > section');
const headers = document.querySelectorAll('main > section > h2');
assert.isAtLeast(sections.length, 1);
assert.equal(sections.length, headers.length);
```

Your `h2` elements should not be empty.

```js
const headers = document.querySelectorAll('main > section > h2');
assert.isAtLeast(headers.length, 1);
headers.forEach(header => assert.notEqual(header.innerHTML.trim(), ''));
```

Your `body` element should have a top and bottom padding of `50px`.

```js
const body = window.getComputedStyle(document.querySelector('body'));
assert.equal(body?.paddingTop, '50px');
assert.equal(body?.paddingBottom, '50px');
```

Your `body` element should have a top and bottom margin of `0`.

```js
const body = new __helpers.CSSHelp(document).getStyle('body');
assert.equal(body?.marginTop, '0px');
assert.equal(body?.marginBottom, '0px');
```

Your `body` element should have a left and right margin of `auto`.

```js
const body = new __helpers.CSSHelp(document).getStyle('body');
assert.equal(body?.marginRight, 'auto');
assert.equal(body?.marginLeft, 'auto');
```

Your `body` element should set its width using `vw`.

```js
assert.isTrue(new __helpers.CSSHelp(document).getStyle('body')?.width?.endsWith('vw'));
```

Your `body` should use `calc` to set its `min-height` to `100vh - 100px`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('body')?.minHeight, ['calc(-100px + 100vh)', 'calc(100vh - 100px)']);
```

You should have at least one `hr` element.

```js
assert.isAtLeast(document.querySelectorAll('hr')?.length, 1);
```

The width of your `hr` elements should be set using a percent value.

```js
assert.isTrue([...new __helpers.CSSHelp(document).getCSSRules().values()].some(rule => 
  rule.selectorText?.split(',').some(selector => 
    selector.trim() === 'hr' && 
    rule.style.width?.endsWith('%')
  )
));
```

The width of your `section` elements should be set using a percent value.

```js
assert.isTrue([...new __helpers.CSSHelp(document).getCSSRules().values()].some(rule => 
  rule.selectorText?.split(',').some(selector => 
    selector.trim() === 'section' && 
    rule.style.width?.endsWith('%')
  )
));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Build an Event Flyer Page</title>
</head>

<body>

</body>

</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Build an Event Flyer Page</title>
  <link rel="stylesheet" href="styles.css">
</head>

<body>

  <header>
    <img src="https://cdn.freecodecamp.org/curriculum/labs/rock.jpg">
    <h1>Pet Rock Festival</h1>
    <p>Join us for the first annual Pet Rock Festival!</p>
    <p><b>When:</b> <time datetime="2025-10-03">October 3rd</time> <b>Where:</b> Boulder Park</p>
  </header>

  <hr>

  <main>
    <section>
      <h2>Festival Highlights</h2>
      <ul>
        <li>Pet Rock Obedience Shows</li>
        <li>Best Dressed Pet Rock Contest</li>
        <li>Pet Rock Uphill Racing</li>
      </ul>
    </section>

    <section>
      <h2>Special Guests</h2>
      <ul>
        <li>John Gravel</li>
        <li>Wendy Cobblestone</li>
      </ul>
    </section>

    <section>
      <h2>Food Trucks</h2>
      <ul>
        <li>Rock 'n' Roll Tacos</li>
        <li>Granite Grill</li>
        <li>Stone Cold Smoothies</li>
      </ul>
    </section>
  </main>

  <hr>

<footer>
  <p>&copy; 2025 Pet Rock Festival</p>
</footer>

</body>

</html>
```

```css
html {
  background-color: gray;
}

body {
  padding: 50px 10px;
  margin: 0 auto;
  width: 90vw;
  min-height: calc(100vh - 100px);
  background-color: white;
  font-family: sans-serif;
  text-align: center;
}

hr {
  margin: 30px auto;
  width: 80%;
  background-color: black;
  height: 2px;
}

main {
  margin: 0 auto;
}

section {
  text-align: center;
  padding: 50px 5px;
  vertical-align: top;
  display: inline-block;
  min-height: 100px;
  width: 30%;
}

ul {
  text-align: left;
  list-style: inside;
  padding-left: 10px;
}
```
