---
id: a5deed1811a43193f9f1c841
title: Implement an Element Skipper
challengeType: 26
dashedName: implement-an-element-skipper
---

# --description--

In this lab you will create a function that skips elements in an array until it finds an acceptable one based on a specific test function.

For example, for an array like `[1, 1, 1, 2, 1, 1, 1]` and a test function `function(n) {return n === 2}`, the first element that is acceptable for this is the one at index 3, so all the elements before that need to be discarded, and the output should be the remaining elements `[2, 1, 1, 1]`.

**Objective**: Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories**

1. You should have a `dropElements` function that accepts an array (`arr`) and a function (`func`) as arguments.
1. The `dropElements` function should iterate through the array and remove elements starting from the first one until `func` returns `true` for an element.
1. The `dropElements` function should return the remaining elements in the array if the condition is met.
1. If the condition is never satisfied, it should return an empty array.

# --hints--

You should have a `dropElements` function.

```js
assert.isFunction(dropElements);
```

`dropElements([1, 2, 3, 4], function(n) {return n >= 3;})` should return `[3, 4]`.

```js
assert.deepEqual(dropElements([1, 2, 3, 4], function(n) {return n >= 3;}), [3, 4]);
```

`dropElements([0, 1, 0, 1], function(n) {return n === 1;})` should return `[1, 0, 1]`.

```js
assert.deepEqual(dropElements([0, 1, 0, 1], function(n) {return n === 1;}), [1, 0, 1]);
```

`dropElements([1, 2, 3], function(n) {return n > 0;})` should return `[1, 2, 3]`.

```js
assert.deepEqual(dropElements([1, 2, 3], function(n) {return n > 0;}), [1, 2, 3]);
```

`dropElements([1, 2, 3, 4], function(n) {return n > 5;})` should return `[]`.

```js
assert.deepEqual(dropElements([1, 2, 3, 4], function(n) {return n > 5;}), []);
```

`dropElements([1, 2, 3, 7, 4], function(n) {return n > 3;})` should return `[7, 4]`.

```js
assert.deepEqual(dropElements([1, 2, 3, 7, 4], function(n) {return n > 3;}), [7, 4]);
```

`dropElements([1, 2, 3, 9, 2], function(n) {return n > 2;})` should return `[3, 9, 2]`.

```js
assert.deepEqual(dropElements([1, 2, 3, 9, 2], function(n) {return n > 2;}), [3, 9, 2]);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function dropElements(arr, func) {
  while (arr.length > 0 && !func(arr[0])) {
    arr.shift();
  }
  return arr;
}
```
