---
id: 685239f0cad43c7a909cbd98
title: Debug a Pet Adoption Page
challengeType: 25
dashedName: lab-debug-pet-adoption-page
# Purposefully removed the demo type because I don't want any example to show since this is a debugging project.
---

# --description--

Sally, a pet adoption store owner, has built her first web page but there are some issues.

Your job is to fix all of the errors so Sally can continue building her page. 

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. Sally wants to use an image of some cats but it is not displaying correctly. You will need to fix the following in the `img` element:
   - Replace the `href` attribute with the correct attribute for the image source. 
   - Replace the `att` attribute with the correct attribute representing short, descriptive text for images.
   - Remove the `</img>` closing tag because `img` elements are void elements and don't have closing tags.
2. Sally wants to use some links to direct users to the dog and cat pages. But the links are not working correctly. You will need to fix the following in the `a` elements:
   - Replace both `src` attributes with the correct attributes used to specify URLs.

# --hints--

Your `img` element should have a `src` attribute instead of the `href` attribute.

```js
const imgEl = document.querySelector("img");
assert.isTrue(imgEl.hasAttribute("src"));
```

Your `img` element should have an `alt` attribute instead of the non-existent `att` attribute.

```js
const imgEl = document.querySelector("img");
assert.isTrue(imgEl.hasAttribute("alt"));
```

Your `img` element should not have a `</img>` closing tag.

```js
assert.notMatch(code, /<\/img>/);
```

Your `a` element with the text `Visit cats page` needs to have an `href` attribute instead of a `src` attribute.

```js
const anchors = document.querySelectorAll("a");
const catLink = Array.from(anchors).find(a => a.textContent.trim() === "Visit cats page");
assert.isDefined(catLink);
assert.isTrue(catLink.hasAttribute("href"));
```

Your `a` element with the text `Visit dogs page` needs to have an `href` attribute instead of a `src` attribute.

```js
const anchors = document.querySelectorAll("a");
const dogLink = Array.from(anchors).find(a => a.textContent.trim() === "Visit dogs page");
assert.isDefined(dogLink);
assert.isTrue(dogLink.hasAttribute("href"));
```

# --seed--

## --seed-contents--

```html
<h1>Welcome XYZ Pet Adoption!</h1>
<p>Consider adopting a pet today. We have cats, dogs, rabbits and more.</p>

<h2>See our cats!</h2>
<img href="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" att="Two tabby kittens sleeping together on a couch."></img>

<h2>Adopt a cat!</h2>
<a src="/cats">Visit cats page</a>

<h2>Adopt a dog!</h2>
<a src="/dogs">Visit dogs page</a>
```

# --solutions--

```html
<h1>Welcome XYZ Pet Adoption!</h1>
<p>Consider adopting a pet today. We have cats, dogs, rabbits and more.</p>

<h2>See our cats!</h2>
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch.">

<h2>Adopt a cat!</h2>
<a href="/cats">Visit cats page</a>

<h2>Adopt a dog!</h2>
<a href="/dogs">Visit dogs page</a>
```
