---
id: 6718d2d59337c822ecb697ff
title: Build a Bank Account Management Program
challengeType: 26
dashedName: build-a-bank-account-management-program
saveSubmissionToDB: true
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab. 

**User Stories:**

1. You should define a class named `BankAccount` with a constructor. The constructor should set the default `balance` to `0` and initialize an empty array named `transactions` to store transaction records as objects. 

2. Each transaction stored in the `transactions` array should be an object with two properties: `type` and `amount`. The `type` property should be either `deposit` or `withdraw`, and the `amount` property should be the amount deposited or withdrawn.

3. You should define a method named `deposit` that takes the deposit amount as a parameter. When the deposit amount is greater than `0`, it should:

   - Push a new object to the transactions array with a type of `deposit` and the amount deposited.
   - Update the balance.   
   - Return `"Successfully deposited $[amount]. New balance: $[balance]"`.

4. If the amount is less than or equal to `0`, the `deposit` method should return `"Deposit amount must be greater than zero."`.

5. You should define a method named `withdraw` that takes an amount as a parameter. This method should update the current balance according to withdrawals. When the amount to be withdrawn is greater than `0` and less than or equal to the current balance, it should:

   - Push a new object to the transactions array with a type of `withdraw` and the amount withdrawn.
   - Update the balance.
   - Return `"Successfully withdrew $[amount]. New balance: $[balance]"`. 

6. If the amount to be withdrawn is less than or equal to `0` or greater than the current balance, the `withdraw` method should return `"Insufficient balance or invalid amount."`.


7. You should define a method named `checkBalance` that returns the current balance in the format `"Current balance: $[balance]"`.

8. You should define a method named `listAllDeposits` that iterates through the transactions array and returns all deposits in the format `"Deposits: amount,amount,..."`.

9. You should define a method named `listAllWithdrawals` that iterates through the transactions array and returns all withdrawals in the format `"Withdrawals: amount,amount,..."`.

10. You should create a new instance of `BankAccount` named `myAccount`.

11. Your `myAccount` bank account should have at least five transactions.

12. Your `myAccount` bank account should have at least two deposits.

13. Your `myAccount` bank account should have at least two withdrawals.

14. Your `myAccount` bank account should have a balance greater than `$100`.

# --hints--

You should define a class named `BankAccount`.

```js
assert.isFunction(BankAccount);
assert.isObject(new BankAccount());
```

The `BankAccount` object should initially have a `balance` of `0` and an empty array `transactions` to store transaction records.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.balance, 0);
assert.equal(myAccount.transactions.length, 0);
```

You should have a `deposit` method that takes the deposit amount as a parameter.

```js
const myAccount = new BankAccount();
assert.isFunction(myAccount.deposit);
assert.lengthOf(myAccount.deposit, 1);
```

You should have a `withdraw` method that takes the withdrawal amount as a parameter.

```js
const myAccount = new BankAccount();
assert.isFunction(myAccount.withdraw);
assert.lengthOf(myAccount.withdraw, 1);
```

You should have a `checkBalance` method that checks the current balance.

```js
const myAccount = new BankAccount();
assert.isFunction(myAccount.checkBalance);
```

You should have a `listAllDeposits` method that lists all deposits.

```js
const myAccount = new BankAccount();
assert.isFunction(myAccount.listAllDeposits);
```

You should have a `listAllWithdrawals` method that lists all withdrawals.

```js
const myAccount = new BankAccount();
assert.isFunction(myAccount.listAllWithdrawals);
```

`BankAccount.deposit(100)` should return `"Successfully deposited $100. New balance: $100"`.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.deposit(100), "Successfully deposited $100. New balance: $100")

// prevent hardcoding
assert.equal(myAccount.deposit(200), "Successfully deposited $200. New balance: $300")

```

`BankAccount.deposit(-50)` should return `"Deposit amount must be greater than zero."`.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.deposit(-50), "Deposit amount must be greater than zero.")

// prevent hardcoding
assert.equal(myAccount.deposit(-30), "Deposit amount must be greater than zero.")

```

`BankAccount.deposit(0)` should return `"Deposit amount must be greater than zero."`.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.deposit(0), "Deposit amount must be greater than zero.")
```

When the account balance is `100`, `BankAccount.withdraw(150)` should return `"Insufficient balance or invalid amount."`.

```js
const myAccount = new BankAccount();
myAccount.deposit(100);
assert.equal(myAccount.withdraw(150), "Insufficient balance or invalid amount.")

// prevent hardcoding
assert.equal(myAccount.withdraw(250), "Insufficient balance or invalid amount.")

```

`BankAccount.withdraw(-50)` should return `"Insufficient balance or invalid amount."`.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.withdraw(-50), "Insufficient balance or invalid amount.")

// prevent hardcoding
assert.equal(myAccount.withdraw(-30), "Insufficient balance or invalid amount.")
```

`BankAccount.withdraw(0)` should return `"Insufficient balance or invalid amount."`.

```js
const myAccount = new BankAccount();
assert.equal(myAccount.withdraw(0), "Insufficient balance or invalid amount.")
```

When the account balance is `200`, `BankAccount.withdraw(150)` should return `"Successfully withdrew $150. New balance: $50"`.

```js
const myAccount = new BankAccount();
myAccount.deposit(200);
assert.equal(myAccount.withdraw(150), "Successfully withdrew $150. New balance: $50")
```

When the account balance is `200`, `BankAccount.checkBalance()` should return `"Current balance: $200"`.

```js
const myAccount = new BankAccount();
myAccount.deposit(200);
assert.equal(myAccount.checkBalance(), "Current balance: $200")

// prevent hardcoding
myAccount.deposit(300);
assert.equal(myAccount.checkBalance(), "Current balance: $500")
```

When you deposit `10`, `35`, `90`, the `listAllDeposits` method should return `"Deposits: 10,35,90"`.

```js
const myAccount = new BankAccount();
myAccount.deposit(10);
myAccount.deposit(35);
myAccount.deposit(90);
assert.equal(myAccount.listAllDeposits(), "Deposits: 10,35,90")
```

When you withdraw `20`, `50`, `100`, the `listAllWithdrawals` method should return `"Withdrawals: 20,50,100"`.

```js
const myAccount = new BankAccount();
myAccount.deposit(500);

myAccount.withdraw(20);
myAccount.withdraw(50);
myAccount.withdraw(100);
assert.equal(myAccount.listAllWithdrawals(), "Withdrawals: 20,50,100")
```

You should have an instance of `BankAccount` named `myAccount`.

```js
assert.exists(myAccount);
assert.instanceOf(myAccount, BankAccount);
```

Your `myAccount` bank account should have at least five transactions.

```js
assert.isAtLeast(myAccount.transactions.length, 5);
```

Your `myAccount` bank account should have at least two deposits.

```js
const depositCount = myAccount.transactions.filter(transaction => transaction.type === "deposit").length;
assert.isAtLeast(depositCount, 2);
```

Your `myAccount` bank account should have at least two withdrawals.

```js
const withdrawalCount = myAccount.transactions.filter(transaction => transaction.type === "withdraw").length;
assert.isAtLeast(withdrawalCount, 2);
```


Your `myAccount` bank account should have a balance greater than `$100`.

```js
assert.isAbove(myAccount.balance, 100);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
class BankAccount {
    constructor() {
        this.balance = 0;
        this.transactions = [];
    }

    deposit(amount) {
        if (amount > 0) {
            this.transactions.push({ type: 'deposit', amount });
            this.balance += amount;
            return `Successfully deposited $${amount}. New balance: $${this.balance}`;
        } else {
            return 'Deposit amount must be greater than zero.';
        }
    }

    withdraw(amount) {
        if (amount > 0 && amount <= this.balance) {
            this.transactions.push({ type: 'withdraw', amount });
            this.balance -= amount;
            return `Successfully withdrew $${amount}. New balance: $${this.balance}`;
        } else {
            return 'Insufficient balance or invalid amount.';
        }
    }

    checkBalance() {
        return `Current balance: $${this.balance}`;
    }

    listAllDeposits() {
        const deposits = this.transactions
            .filter(transaction => transaction.type === 'deposit')
            .map(transaction => transaction.amount);
        return `Deposits: ${deposits}`;
    }

    listAllWithdrawals() {
        const withdrawals = this.transactions
            .filter(transaction => transaction.type === 'withdraw')
            .map(transaction => transaction.amount);
        return `Withdrawals: ${withdrawals}`;
    }
}

const myAccount = new BankAccount();
  
console.log(myAccount.deposit(0)); 
console.log(myAccount.deposit(20)); 
console.log(myAccount.deposit(500));
console.log(myAccount.withdraw(30));
console.log(myAccount.withdraw(55));
console.log(myAccount.withdraw(100));
console.log(myAccount.checkBalance());
console.log(myAccount.listAllDeposits());
console.log(myAccount.listAllWithdrawals());
```
