---
id: 69306364df283fcaff2e1ad7
title: "Challenge 146: Left-Handed Seat at the Table"
challengeType: 29
dashedName: challenge-146
---

# --description--

Given a 4x2 matrix (array of arrays) representing the seating arrangement for a meal, determine how many seats a left-handed person can sit at.

- A left-handed person cannot sit where a right-handed person would be in the seat to the immediate left of them.

In the given matrix:

- An `"R"` is a seat occupied by a right-handed person.
- An `"L"` is a seat occupied by a left-handed person.
- A `"U"` is an unoccupied seat.
- Only unoccupied seats are available to sit at.
- The seats in the top row are facing "down", and the seats in the bottom row are facing "up" (like a table), so left and right are relative to the seat's orientation.
- Corner seats only have one seat next to them.

For example, in the given matrix:

```json
[
  ["U", "R", "U", "L"],
  ["U", "R", "R", "R"]
]
```

The top-left seat is cannot be sat in because there's a right-handed person to the left. The other two open seats can be sat in because there isn't a right-handed person to the left.

# --hints--

`find_left_handed_seats([["U", "R", "U", "L"], ["U", "R", "R", "R"]])` should return `2`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(find_left_handed_seats([["U", "R", "U", "L"], ["U", "R", "R", "R"]]), 2)`)
}})
```

`find_left_handed_seats([["U", "U", "U", "U"], ["U", "U", "U", "U"]])` should return `8`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(find_left_handed_seats([["U", "U", "U", "U"], ["U", "U", "U", "U"]]), 8)`)
}})
```

`find_left_handed_seats([["U", "R", "U", "R"], ["L", "R", "R", "U"]])` should return `0`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(find_left_handed_seats([["U", "R", "U", "R"], ["L", "R", "R", "U"]]), 0)`)
}})
```

`find_left_handed_seats([["L", "U", "R", "R"], ["L", "U", "R", "R"]])` should return `1`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(find_left_handed_seats([["L", "U", "R", "R"], ["L", "U", "R", "R"]]), 1)`)
}})
```

`find_left_handed_seats([["U", "R", "U", "U"], ["U", "U", "L", "U"]])` should return `5`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(find_left_handed_seats([["U", "R", "U", "U"], ["U", "U", "L", "U"]]), 5)`)
}})
```

# --seed--

## --seed-contents--

```py
def find_left_handed_seats(table):

    return table
```

# --solutions--

```py
def find_left_handed_seats(table):
    available_seats = 0
    top_row, bottom_row = table

    for i in range(len(top_row)):
        if top_row[i] == "U":
            if i == len(top_row) - 1:
                available_seats += 1
            elif top_row[i + 1] != "R":
                available_seats += 1

    for i in range(len(bottom_row)):
        if bottom_row[i] == "U":
            if i == 0:
                available_seats += 1
            elif bottom_row[i - 1] != "R":
                available_seats += 1

    return available_seats
```
