---
id: 6939b873185d8e00d453563c
title: "Challenge 157: Markdown Link Parser"
challengeType: 28
dashedName: challenge-157
---

# --description--

Given the string of a link in Markdown, return the equivalent HTML string.

A Markdown image has the following format: `"[link_text](link_url)"`. Return the string of the HTML `a` tag with the `href` set to the `link_url` and the `link_text` as the tag content.

For example, given `"[freeCodeCamp](https://freecodecamp.org/)"` return `'<a href="https://freecodecamp.org/">freeCodeCamp</a>'`;

Note: The console may not display HTML tags in strings when logging messages — check the browser console to see logs with tags included.

# --hints--

`parseLink("[freeCodeCamp](https://freecodecamp.org/)")` should return `'<a href="https://freecodecamp.org/">freeCodeCamp</a>'`.

```js
assert.equal(parseLink("[freeCodeCamp](https://freecodecamp.org/)"), '<a href="https://freecodecamp.org/">freeCodeCamp</a>');
```

`parseLink("[Donate to our charity.](https://www.freecodecamp.org/donate/)")` should return `'<a href="https://www.freecodecamp.org/donate/">Donate to our charity.</a>'`.

```js
assert.equal(parseLink("[Donate to our charity.](https://www.freecodecamp.org/donate/)"), '<a href="https://www.freecodecamp.org/donate/">Donate to our charity.</a>');
```

`parseLink("[Contribute to our repository at https://github.com/freeCodeCamp/freeCodeCamp.](https://github.com/freeCodeCamp/freeCodeCamp/)")` should return `'<a href="https://github.com/freeCodeCamp/freeCodeCamp/">Contribute to our repository at https://github.com/freeCodeCamp/freeCodeCamp.</a>'`.

```js
assert.equal(parseLink("[Contribute to our repository at https://github.com/freeCodeCamp/freeCodeCamp.](https://github.com/freeCodeCamp/freeCodeCamp/)"), '<a href="https://github.com/freeCodeCamp/freeCodeCamp/">Contribute to our repository at https://github.com/freeCodeCamp/freeCodeCamp.</a>');
```

# --seed--

## --seed-contents--

```js
function parseLink(markdown) {

  return markdown;
}
```

# --solutions--

```js
function parseLink(markdown) {
  const match = markdown.match(/\[(.*?)\]\((.*?)\)/);

  const [, text, url] = match;
  return `<a href="${url}">${text}</a>`;
}
```
