---
id: 69373793f5a867f769cde137
title: "Challenge 152: Circular Prime"
challengeType: 28
dashedName: challenge-152
---

# --description--

Given an integer, determine if it is a circular prime.

A circular prime is an integer where all rotations of its digits are themselves prime.

For example, `197` is a circular prime because all rotations of its digits: `197`, `971`, and `719`, are prime numbers.

# --hints--

`isCircularPrime(197)` should return `true`.

```js
assert.isTrue(isCircularPrime(197));
```

`isCircularPrime(23)` should return `false`.

```js
assert.isFalse(isCircularPrime(23));
```

`isCircularPrime(13)` should return `true`.

```js
assert.isTrue(isCircularPrime(13));
```

`isCircularPrime(89)` should return `false`.

```js
assert.isFalse(isCircularPrime(89));
```

`isCircularPrime(1193)` should return `true`.

```js
assert.isTrue(isCircularPrime(1193));
```

# --seed--

## --seed-contents--

```js
function isCircularPrime(n) {

  return n;
}
```

# --solutions--

```js
function isPrime(n) {
  if (n < 2) return false;
  for (let i = 2, sqrt = Math.floor(Math.sqrt(n)); i <= sqrt; i++) {
    if (n % i === 0) return false;
  }
  return true;
}

function rotations(num) {
  const str = num.toString();
  const result = [];
  for (let i = 0; i < str.length; i++) {
    result.push(str.slice(i) + str.slice(0, i));
  }
  return result.map(Number);
}

function isCircularPrime(num) {
  const rots = rotations(num);
  return rots.every(isPrime);
}
```
