---
id: 69272dcf1c24b44fd79137c3
title: "Challenge 140: SCREAMING_SNAKE_CASE"
challengeType: 28
dashedName: challenge-140
---

# --description--

Given a string representing a variable name, return the variable name converted to SCREAMING_SNAKE_CASE.

The given variable names will be written in one of the following formats:

- `camelCase`
- `PascalCase`
- `snake_case`
- `kebab-case`

In the above formats, words are separated by an underscore (`_`), a hyphen (`-`), or a new word starts with a capital letter.

To convert to SCREAMING_SNAKE_CASE:

- Make all letters uppercase
- Separate words with an underscore (`_`)

# --hints--

`toScreamingSnakeCase("userEmail")` should return `"USER_EMAIL"`.

```js
assert.equal(toScreamingSnakeCase("userEmail"), "USER_EMAIL");
```

`toScreamingSnakeCase("UserPassword")` should return `"USER_PASSWORD"`.

```js
assert.equal(toScreamingSnakeCase("UserPassword"), "USER_PASSWORD");
```

`toScreamingSnakeCase("user_id")` should return `"USER_ID"`.

```js
assert.equal(toScreamingSnakeCase("user_id"), "USER_ID");
```

`toScreamingSnakeCase("user-address")` should return `"USER_ADDRESS"`.

```js
assert.equal(toScreamingSnakeCase("user-address"), "USER_ADDRESS");
```

`toScreamingSnakeCase("username")` should return `"USERNAME"`.

```js
assert.equal(toScreamingSnakeCase("username"), "USERNAME");
```

# --seed--

## --seed-contents--

```js
function toScreamingSnakeCase(variableName) {

  return variableName;
}
```

# --solutions--

```js
function toScreamingSnakeCase(variableName) {
  let temp = variableName.replace(/[-_]+/g, ' ');
  temp = temp.replace(/([a-z0-9])([A-Z])/g, '$1 $2');
  const words = temp.trim().split(/\s+/);
  return words.join('_').toUpperCase();;
}
```
