---
id: 691b559495c5cb5a37b9b488
title: "Challenge 128: Consonant Count"
challengeType: 28
dashedName: challenge-128
---

# --description--

Given a string and a target number, determine whether the string contains exactly the target number of consonants.

- Consonants are all alphabetic characters except `"a"`, `"e"`, `"i"`, `"o"`, and `"u"` in any case.
- Ignore digits, punctuation, spaces, and other non-letter characters when counting.

# --hints--

`hasConsonantCount("helloworld", 7)` should return `true`.

```js
assert.isTrue(hasConsonantCount("helloworld", 7));
```

`hasConsonantCount("eieio", 5)` should return `false`.

```js
assert.isFalse(hasConsonantCount("eieio", 5));
```

`hasConsonantCount("freeCodeCamp Rocks!", 11)` should return `true`.

```js
assert.isTrue(hasConsonantCount("freeCodeCamp Rocks!", 11));
```

`hasConsonantCount("Th3 Qu!ck Br0wn F0x Jump5 0ver Th3 L@zy D0g.", 24)` should return `false`.

```js
assert.isFalse(
  hasConsonantCount("Th3 Qu!ck Br0wn F0x Jump5 0ver Th3 L@zy D0g.", 24)
);
```

`hasConsonantCount("Th3 Qu!ck Br0wn F0x Jump5 0ver Th3 L@zy D0g.", 23)` should return `true`.

```js
assert.isTrue(
  hasConsonantCount("Th3 Qu!ck Br0wn F0x Jump5 0ver Th3 L@zy D0g.", 23)
);
```

# --seed--

## --seed-contents--

```js
function hasConsonantCount(text, target) {
  return text;
}
```

# --solutions--

```js
function hasConsonantCount(text, target) {
  const vowels = new Set(["a", "e", "i", "o", "u"]);
  let count = 0;

  for (const char of text.toLowerCase()) {
    if (/[a-z]/.test(char) && !vowels.has(char)) {
      count++;
    }
  }

  return count === target;
}
```
