---
id: 691b559495c5cb5a37b9b481
title: "Challenge 121: Most Frequent"
challengeType: 28
dashedName: challenge-121
---

# --description--

Given an array of elements, return the element that appears most frequently.

- There will always be a single most frequent element.

# --hints--

`mostFrequent(["a", "b", "a", "c"])` should return `"a"`.

```js
assert.equal(mostFrequent(["a", "b", "a", "c"]), "a");
```

`mostFrequent([2, 3, 5, 2, 6, 3, 2, 7, 2, 9])` should return `2`.

```js
assert.equal(mostFrequent([2, 3, 5, 2, 6, 3, 2, 7, 2, 9]), 2);
```

`mostFrequent([true, false, "false", "true", false])` should return `false`.

```js
assert.isFalse(mostFrequent([true, false, "false", "true", false]));
```

`mostFrequent([40, 20, 70, 30, 10, 40, 10, 50, 40, 60])` should return `40`.

```js
assert.equal(mostFrequent([40, 20, 70, 30, 10, 40, 10, 50, 40, 60]), 40);
```

# --seed--

## --seed-contents--

```js
function mostFrequent(arr) {
  return arr;
}
```

# --solutions--

```js
function mostFrequent(arr) {
  const freq = {};
  let maxCount = 0;
  let mostElem = null;

  for (const el of arr) {
    freq[el] = (freq[el] || 0) + 1;
    if (freq[el] > maxCount) {
      maxCount = freq[el];
      mostElem = el;
    }
  }

  return mostElem;
}
```
