---
id: 691b559495c5cb5a37b9b480
title: "Challenge 120: Pounds to Kilograms"
challengeType: 28
dashedName: challenge-120
---

# --description--

Given a weight in pounds as a number, return the string `"(lbs) pounds equals (kgs) kilograms."`.

- Replace `"(lbs)"` with the input number.
- Replace `"(kgs)"` with the input converted to kilograms, rounded to two decimals and always include two decimal places in the value.
- 1 pound equals 0.453592 kilograms.
- If the input is `1`, use `"pound"` instead of `"pounds"`.
- If the converted value is `1`, use `"kilogram"` instead of `"kilograms"`.

# --hints--

`convertToKgs(1)` should return `"1 pound equals 0.45 kilograms."`.

```js
assert.equal(convertToKgs(1), "1 pound equals 0.45 kilograms.");
```

`convertToKgs(0)` should return `"0 pounds equals 0.00 kilograms."`.

```js
assert.equal(convertToKgs(0), "0 pounds equals 0.00 kilograms.");
```

`convertToKgs(100)` should return `"100 pounds equals 45.36 kilograms."`.

```js
assert.equal(convertToKgs(100), "100 pounds equals 45.36 kilograms.");
```

`convertToKgs(2.5)` should return `"2.5 pounds equals 1.13 kilograms."`.

```js
assert.equal(convertToKgs(2.5), "2.5 pounds equals 1.13 kilograms.");
```

`convertToKgs(2.20462)` should return `"2.20462 pounds equals 1.00 kilogram."`.

```js
assert.equal(convertToKgs(2.20462), "2.20462 pounds equals 1.00 kilogram.");
```

# --seed--

## --seed-contents--

```js
function convertToKgs(lbs) {
  return lbs;
}
```

# --solutions--

```js
function convertToKgs(lbs) {
  const KG_PER_POUND = 0.453592;
  const kgs = (lbs * KG_PER_POUND).toFixed(2);

  const poundWord = lbs === 1 ? "pound" : "pounds";
  const kilogramWord = kgs === "1.00" ? "kilogram" : "kilograms";

  return `${lbs} ${poundWord} equals ${kgs} ${kilogramWord}.`;
}
```
