---
id: 69162d64f96574d9bb629f03
title: "Challenge 118: Date Formatter"
challengeType: 28
dashedName: challenge-118
---

# --description--

Given a date in the format `"Month day, year"`, return the date in the format `"YYYY-MM-DD"`.

- The given month will be the full English month name. For example: `"January"`, `"February"`, etc.
- In the return value, pad the month and day with leading zeros if necessary to ensure two digits.

For example, given `"December 6, 2025"`, return `"2025-12-06"`.

# --hints--

`formatDate("December 6, 2025")` should return `"2025-12-06"`.

```js
assert.equal(formatDate("December 6, 2025"), "2025-12-06");
```

`formatDate("January 1, 2000")` should return `"2000-01-01"`.

```js
assert.equal(formatDate("January 1, 2000"), "2000-01-01");
```

`formatDate("November 11, 1111")` should return `"1111-11-11"`.

```js
assert.equal(formatDate("November 11, 1111"), "1111-11-11");
```

`formatDate("September 7, 512")` should return `"512-09-07"`.

```js
assert.equal(formatDate("September 7, 512"), "512-09-07");
```

`formatDate("May 4, 1950")` should return `"1950-05-04"`.

```js
assert.equal(formatDate("May 4, 1950"), "1950-05-04");
```

`formatDate("February 29, 1992")` should return `"1992-02-29"`.

```js
assert.equal(formatDate("February 29, 1992"), "1992-02-29");
```

# --seed--

## --seed-contents--

```js
function formatDate(dateString) {

  return dateString;
}
```

# --solutions--

```js
function formatDate(dateString) {
  const months = {
    January: "01",
    February: "02",
    March: "03",
    April: "04",
    May: "05",
    June: "06",
    July: "07",
    August: "08",
    September: "09",
    October: "10",
    November: "11",
    December: "12"
  };

  const [month, day, year] = dateString.replace(",", "").split(" ");

  return `${year}-${months[month]}-${day.padStart(2, "0")}`;
}
```
