---
id: 69162d64f96574d9bb629f00
title: "Challenge 115: Markdown Ordered List Item Converter"
challengeType: 28
dashedName: challenge-115
---

# --description--

Given a string representing an ordered list item in Markdown, return the equivalent HTML string.

A valid ordered list item in Markdown must:

- Start with zero or more spaces, followed by
- A number (1 or greater) and a period (`.`), followed by
- At least one space, and then
- The list item text.

If the string doesn't have the exact format above, return `"Invalid format"`. Otherwise, wrap the list item text in `li` tags and return the string.

For example, given `"1. My item"`, return `"<li>My item</li>"`.

Note: The console may not display HTML tags in strings when logging messages. Check the browser console to see logs with tags included.

# --hints--

`convertListItem("1. My item")` should return `"<li>My item</li>"`.

```js
assert.equal(convertListItem("1. My item"), "<li>My item</li>");
```

`convertListItem(" 1.  Another item")` should return `"<li>Another item</li>"`.

```js
assert.equal(convertListItem(" 1.  Another item"), "<li>Another item</li>");
```

`convertListItem("1 . invalid item")` should return `"Invalid format"`.

```js
assert.equal(convertListItem("1 . invalid item"), "Invalid format");
```

`convertListItem("2. list item text")` should return `"<li>list item text</li>"`.

```js
assert.equal(convertListItem("2. list item text"), "<li>list item text</li>");
```

`convertListItem(". invalid again")` should return `"Invalid format"`.

```js
assert.equal(convertListItem(". invalid again"), "Invalid format");
```

`convertListItem("A. last invalid")` should return `"Invalid format"`.

```js
assert.equal(convertListItem("A. last invalid"), "Invalid format");
```

# --seed--

## --seed-contents--

```js
function convertListItem(markdown) {

  return markdown;
}
```

# --solutions--

```js
function convertListItem(markdown) {
  const match = markdown.match(/^\s*(\d+)\.\s+(.+)$/);
  if (!match) return "Invalid format";

  const text = match[2];
  return `<li>${text}</li>`;
}
```
