---
id: 69162d64f96574d9bb629efd
title: "Challenge 112: AI Detector"
challengeType: 28
dashedName: challenge-112
---

# --description--

Today's challenge is inspired by the release of ChatGPT on November 30, 2022.

Given a string of one or more sentences, determine if it was likely generated by AI using the following rules:

- It contains two or more dashes (`-`).
- It contains two or more sets of parenthesis (`()`). Text can be within the parenthesis.
- It contains three or more words with 7 or more letters.

- Words are separated by a single space and only consist of letters (`A-Z`). Don't include punctuation or other non-letters as part of a word.

If the given sentence meets any of the rules above, return `"AI"`, otherwise, return `"Human"`.

# --hints--

`detectAI("The quick brown fox jumped over the lazy dog.")` should return `"Human"`.

```js
assert.equal(detectAI("The quick brown fox jumped over the lazy dog."), "Human");
```

`detectAI("The hypersonic brown fox - jumped (over) the lazy dog.")` should return `"Human"`.

```js
assert.equal(detectAI("The hypersonic brown fox - jumped (over) the lazy dog."), "Human");
```

`detectAI("Yes - you're right! I made a mistake there - let me try again.")` should return `"AI"`.

```js
assert.equal(detectAI("Yes - you're right! I made a mistake there - let me try again."), "AI");
```

`detectAI("The extraordinary students were studying vivaciously.")` should return `"AI"`.

```js
assert.equal(detectAI("The extraordinary students were studying vivaciously."), "AI");
```

`detectAI("The (excited) student was (coding) in the library.")` should return `"AI"`.

```js
assert.equal(detectAI("The (excited) student was (coding) in the library."), "AI");
```

# --seed--

## --seed-contents--

```js
function detectAI(text) {

  return text;
}
```

# --solutions--

```js
function detectAI(text) {
  const dashCount = (text.match(/-/g) || []).length;
  if (dashCount >= 2) return "AI";

  const parenCount = (text.match(/\([^)]*\)/g) || []).length;
  if (parenCount >= 2) return "AI";

  const words = text.split(" ");
  const longWordCount = words.filter(w => w.replace(/[^A-Za-z]/g, "").length >= 7).length;
  if (longWordCount >= 3) return "AI";

  return "Human";
}
```
