---
id: 68ffb91507a5b645769328c9
title: "Challenge 106: Message Validator"
challengeType: 28
dashedName: challenge-106
---

# --description--

Given a message string and a validation string, determine if the message is valid.

- A message is valid if each word in the message starts with the corresponding letter in the validation string, in order.
- Letters are case-insensitive.
- Words in the message are separated by single spaces.

# --hints--

`isValidMessage("hello world", "hw")` should return `true`.

```js
assert.isTrue(isValidMessage("hello world", "hw"));
```

`isValidMessage("ALL CAPITAL LETTERS", "acl")` should return `true`.

```js
assert.isTrue(isValidMessage("ALL CAPITAL LETTERS", "acl"));
```

`isValidMessage("Coding challenge are boring.", "cca")` should return `false`.

```js
assert.isFalse(isValidMessage("Coding challenge are boring.", "cca"));
```

`isValidMessage("The quick brown fox jumps over the lazy dog.", "TQBFJOTLD")` should return `true`.

```js
assert.isTrue(isValidMessage("The quick brown fox jumps over the lazy dog.", "TQBFJOTLD"));
```

`isValidMessage("The quick brown fox jumps over the lazy dog.", "TQBFJOTLDT")` should return `false`.

```js
assert.isFalse(isValidMessage("The quick brown fox jumps over the lazy dog.", "TQBFJOTLDT"));
```

# --seed--

## --seed-contents--

```js
function isValidMessage(message, validator) {

  return message;
}
```

# --solutions--

```js
function isValidMessage(message, validation) {
  const words = message.split(" ");
  
  if (words.length !== validation.length) return false;

  for (let i = 0; i < words.length; i++) {
    if (words[i][0].toLowerCase() !== validation[i].toLowerCase()) {
      return false;
    }
  }

  return true;
}
```
