---
id: 68ffb91507a5b645769328c4
title: "Challenge 101: Markdown Heading Converter"
challengeType: 28
dashedName: challenge-101
---

# --description--

Given a string representing a Markdown heading, return the equivalent HTML heading.

A valid Markdown heading must:

- Start with zero or more spaces, followed by
- 1 to 6 hash characters (`#`) in a row, then
- At least one space. And finally,
- The heading text.

The number of hash symbols determines the heading level. For example, one hash symbol corresponds to an `h1` tag, and six hash symbols correspond to an `h6` tag.

If the given string doesn't have the exact format above, return `"Invalid format"`.

For example, given `"# My level 1 heading"`, return `"<h1>My level 1 heading</h1>"`.

Note: The console may not display HTML tags in strings when logging messages. Check the browser console to see logs with tags included.

# --hints--

`convert("# My level 1 heading")` should return `"<h1>My level 1 heading</h1>"`.

```js
assert.equal(convert("# My level 1 heading"), "<h1>My level 1 heading</h1>");
```

`convert("My heading")` should return `"Invalid format"`.

```js
assert.equal(convert("My heading"), "Invalid format");
```

`convert("##### My level 5 heading")` should return `"<h5>My level 5 heading</h5>"`.

```js
assert.equal(convert("##### My level 5 heading"), "<h5>My level 5 heading</h5>");
```

`convert("#My heading")` should return `"Invalid format"`.

```js
assert.equal(convert("#My heading"), "Invalid format");
```

`convert("  ###  My level 3 heading")` should return `"<h3>My level 3 heading</h3>"`.

```js
assert.equal(convert("  ###  My level 3 heading"), "<h3>My level 3 heading</h3>");
```

`convert("####### My level 7 heading")` should return `"Invalid format"`.

```js
assert.equal(convert("####### My level 7 heading"), "Invalid format");
```

`convert("## My #2 heading")` should return `"<h2>My #2 heading</h2>"`.

```js
assert.equal(convert("## My #2 heading"), "<h2>My #2 heading</h2>");
```

# --seed--

## --seed-contents--

```js
function convert(heading) {

  return heading;
}
```

# --solutions--

```js
function convert(heading) {
  const trimmed = heading.trim()

  if (!/^#{1,6}\s+\S+/.test(trimmed)) return "Invalid format"

  const hashCount = trimmed.indexOf(' ');
  const text = trimmed.slice(hashCount).trimStart();

  return `<h${hashCount}>${text}</h${hashCount}>`;
}
```
