---
id: 68f6587287ad1f4ad39b0c85
title: "Challenge 99: Fingerprint Test"
challengeType: 28
dashedName: challenge-99
---

# --description--

Given two strings representing fingerprints, determine if they are a match using the following rules:

- Each fingerprint will consist only of lowercase letters (`a-z`).
- Two fingerprints are considered a match if:
  - They are the same length.
  - The number of differing characters does not exceed 10% of the fingerprint length.

# --hints--

`isMatch("helloworld", "helloworld")` should return `true`.

```js
assert.isTrue(isMatch("helloworld", "helloworld"));
```

`isMatch("helloworld", "helloworlds")` should return `false`.

```js
assert.isFalse(isMatch("helloworld", "helloworlds"));
```

`isMatch("helloworld", "jelloworld")` should return `true`.

```js
assert.isTrue(isMatch("helloworld", "jelloworld"));
```

`isMatch("thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthelazydog")` should return `true`.

```js
assert.isTrue(isMatch("thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthelazydog"));
```

`isMatch("theslickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthehazydog")` should return `true`.

```js
assert.isTrue(isMatch("theslickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthehazydog"));
```

`isMatch("thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthehazycat")` should return `false`.

```js
assert.isFalse(isMatch("thequickbrownfoxjumpsoverthelazydog", "thequickbrownfoxjumpsoverthehazycat"));
```

# --seed--

## --seed-contents--

```js
function isMatch(fingerprintA, fingerprintB) {

  return fingerprintA;
}
```

# --solutions--

```js
function isMatch(fingerprintA, fingerprintB) {
  if (fingerprintA.length !== fingerprintB.length) return false;

  const length = fingerprintA.length;
  let mismatches = 0;

  for (let i = 0; i < length; i++) {
    if (fingerprintA[i] !== fingerprintB[i]) {
      mismatches++;
      if (mismatches > length * 0.1) return false;
    }
  }

  return true;
}
```
