---
id: 68ee9e3066cfd4eb2328e8a7
title: "Challenge 88: Weekday Finder"
challengeType: 28
dashedName: challenge-88
---

# --description--

Given a string date in the format `YYYY-MM-DD`, return the day of the week.

Valid return days are:

- `"Sunday"`
- `"Monday"`
- `"Tuesday"`
- `"Wednesday"`
- `"Thursday"`
- `"Friday"`
- `"Saturday"`

Be sure to ignore time zones.

# --hints--

`getWeekday("2025-11-06")` should return `Thursday`.

```js
assert.equal(getWeekday("2025-11-06"), "Thursday");
```

`getWeekday("1999-12-31")` should return `Friday`.

```js
assert.equal(getWeekday("1999-12-31"), "Friday");
```

`getWeekday("1111-11-11")` should return `Saturday`.

```js
assert.equal(getWeekday("1111-11-11"), "Saturday");
```

`getWeekday("2112-12-21")` should return `Wednesday`.

```js
assert.equal(getWeekday("2112-12-21"), "Wednesday");
```

`getWeekday("2345-10-01")` should return `Monday`.

```js
assert.equal(getWeekday("2345-10-01"), "Monday");
```

# --seed--

## --seed-contents--

```js
function getWeekday(dateString) {

  return dateString;
}
```

# --solutions--

```js
function getWeekday(dateString) {
  const days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
  const [year, month, day] = dateString.split("-").map(Number);
  const date = new Date(Date.UTC(year, month - 1, day));

  return days[date.getUTCDay()];
}
```
