---
id: 68d30845cc08266018fc46bd
title: "Challenge 77: Duration Formatter"
challengeType: 28
dashedName: challenge-77
---

# --description--

Given an integer number of seconds, return a string representing the same duration in the format `"H:MM:SS"`, where `"H"` is the number of hours, `"MM"` is the number of minutes, and `"SS"` is the number of seconds. Return the time using the following rules:

- Seconds: Should always be two digits.
- Minutes: Should omit leading zeros when they aren't needed. Use `"0"` if the duration is less than one minute.
- Hours: Should be included only if they're greater than zero.

# --hints--

`format(500)` should return `"8:20"`.

```js
assert.equal(format(500), "8:20");
```

`format(4000)` should return `"1:06:40"`.

```js
assert.equal(format(4000), "1:06:40");
```

`format(1)` should return `"0:01"`.

```js
assert.equal(format(1), "0:01");
```

`format(5555)` should return `"1:32:35"`.

```js
assert.equal(format(5555), "1:32:35");
```

`format(99999)` should return `"27:46:39"`.

```js
assert.equal(format(99999), "27:46:39");
```

# --seed--

## --seed-contents--

```js
function format(seconds) {

  return seconds;
}
```

# --solutions--

```js
function format(seconds) {
  const h = Math.floor(seconds / 3600);
  const m = Math.floor((seconds % 3600) / 60);
  const s = seconds % 60;

  const secondsStr = s.toString().padStart(2, "0");
  const minutesStr = m.toString();

  if (h > 0) {
    const hoursStr = h.toString();
    return `${hoursStr}:${minutesStr.padStart(2, "0")}:${secondsStr}`;
  } else {
    return `${minutesStr}:${secondsStr}`;
  }
}
```
