---
id: 68d30845cc08266018fc46bc
title: "Challenge 76: Complementary DNA"
challengeType: 28
dashedName: challenge-76
---

# --description--

Given a string representing a DNA sequence, return its complementary strand using the following rules:

- DNA consists of the letters `"A"`, `"C"`, `"G"`, and `"T"`.
- The letters `"A"` and `"T"` complement each other.
- The letters `"C"` and `"G"` complement each other.

For example, given `"ACGT"`, return `"TGCA"`.

# --hints--

`complementaryDNA("ACGT")` should return `"TGCA"`.

```js
assert.equal(complementaryDNA("ACGT"), "TGCA");
```

`complementaryDNA("ATGCGTACGTTAGC")` should return `"TACGCATGCAATCG"`.

```js
assert.equal(complementaryDNA("ATGCGTACGTTAGC"), "TACGCATGCAATCG");
```

`complementaryDNA("GGCTTACGATCGAAG")` should return `"CCGAATGCTAGCTTC"`.

```js
assert.equal(complementaryDNA("GGCTTACGATCGAAG"), "CCGAATGCTAGCTTC");
```

`complementaryDNA("GATCTAGCTAGGCTAGCTAG")` should return `"CTAGATCGATCCGATCGATC"`.

```js
assert.equal(complementaryDNA("GATCTAGCTAGGCTAGCTAG"), "CTAGATCGATCCGATCGATC");
```

# --seed--

## --seed-contents--

```js
function complementaryDNA(strand) {

  return strand;
}
```

# --solutions--

```js
function complementaryDNA(strand) {
  const complements = { A: "T", T: "A", C: "G", G: "C" };
  return strand
    .split("")
    .map(c => complements[c])
    .join("");
}
```
