---
id: 68cae5b538ff798bbd4da009
title: "Challenge 71: Tip Calculator"
challengeType: 28
dashedName: challenge-71
---

# --description--

Given the price of your meal and a custom tip percent, return an array with three tip values; 15%, 20%, and the custom amount.

- Prices will be given in the format: `"$N.NN"`.
- Custom tip percents will be given in this format: `"25%"`.
- Return amounts in the same `"$N.NN"` format, rounded to two decimal places.

For example, given a `"$10.00"` meal price, and a `"25%"` custom tip value, return `["$1.50", "$2.00", "$2.50"]`.

# --hints--

`calculateTips("$10.00", "25%")` should return `["$1.50", "$2.00", "$2.50"]`.

```js
assert.deepEqual(calculateTips("$10.00", "25%"), ["$1.50", "$2.00", "$2.50"]);
```

`calculateTips("$89.67", "26%")` should return `["$13.45", "$17.93", "$23.31"]`.

```js
assert.deepEqual(calculateTips("$89.67", "26%"), ["$13.45", "$17.93", "$23.31"]);
```

`calculateTips("$19.85", "9%")` should return `["$2.98", "$3.97", "$1.79"]`.

```js
assert.deepEqual(calculateTips("$19.85", "9%"), ["$2.98", "$3.97", "$1.79"]);
```

# --seed--

## --seed-contents--

```js
function calculateTips(mealPrice, customTip) {

  return mealPrice;
}
```

# --solutions--

```js
function calculateTips(mealPrice, customTip) {
  const meal = parseFloat(mealPrice.slice(1));
  const customPercent = parseFloat(customTip.slice(0, -1));
  const tips = [15, 20, customPercent];

  return tips.map(percent => {
    const amount = (meal * percent / 100).toFixed(2);
    return `$${amount}`;
  });
}
```
