---
id: 68cae5b538ff798bbd4da008
title: "Challenge 70: HTML Attribute Extractor"
challengeType: 28
dashedName: challenge-70
---

# --description--

Given a string of a valid HTML element, return the attributes of the element using the following criteria:

- You will only be given one element.
- Attributes will be in the format: `attribute="value"`.
- Return an array of strings with each attribute property and value, separated by a comma, in this format: `["attribute1, value1", "attribute2, value2"]`.
- Return attributes in the order they are given.
- If no attributes are found, return an empty array.

# --hints--

`extractAttributes('<span class="red"></span>')` should return `["class, red"]`.

```js
assert.deepEqual(extractAttributes('<span class="red"></span>'), ["class, red"]);
```

`extractAttributes('<meta charset="UTF-8" />')` should return `["charset, UTF-8"]`.

```js
assert.deepEqual(extractAttributes('<meta charset="UTF-8" />'), ["charset, UTF-8"]);
```

`extractAttributes("<p>Lorem ipsum dolor sit amet</p>")` should return `[]`.

```js
assert.deepEqual(extractAttributes("<p>Lorem ipsum dolor sit amet</p>"), []);
```

`extractAttributes('<input name="email" type="email" required="true" />')` should return `["name, email", "type, email", "required, true"]`.

```js
assert.deepEqual(extractAttributes('<input name="email" type="email" required="true" />'), ["name, email", "type, email", "required, true"]);
```

`extractAttributes('<button id="submit" class="btn btn-primary">Submit</button>')` should return `["id, submit", "class, btn btn-primary"]`.

```js
assert.deepEqual(extractAttributes('<button id="submit" class="btn btn-primary">Submit</button>'), ["id, submit", "class, btn btn-primary"]);
```

# --seed--

## --seed-contents--

```js
function extractAttributes(element) {

  return element;
}
```

# --solutions--

```js
function extractAttributes(element) {
  const regex = /(\w[\w-]*)="([^"]*)"/g;
  const result = [];
  let match;

  while ((match = regex.exec(element)) !== null) {
    const attr = match[1];
    const val = match[2];
    result.push(`${attr}, ${val}`);
  }

  return result;
}
```
