---
id: 68cae5b538ff798bbd4da004
title: "Challenge 66: HTML Tag Stripper"
challengeType: 28
dashedName: challenge-66
---

# --description--

Given a string of HTML code, remove the tags and return the plain text content.

- The input string will contain only valid HTML.
- HTML tags may be nested.
- Remove the tags and any attributes.

For example, `'<a href="#">Click here</a>'` should return `"Click here"`.

# --hints--

`stripTags('<a href="#">Click here</a>')` should return `"Click here"`.

```js
assert.equal(stripTags('<a href="#">Click here</a>'), "Click here");
```

`stripTags('<p class="center">Hello <b>World</b>!</p>')` should return `"Hello World!"`.

```js
assert.equal(stripTags('<p class="center">Hello <b>World</b>!</p>'), "Hello World!");
```

`stripTags('<img src="cat.jpg" alt="Cat">')` should return an empty string (`""`).

```js
assert.equal(stripTags('<img src="cat.jpg" alt="Cat">'), "");
```

`stripTags('<main id="main"><section class="section">section</section><section class="section">section</section></main>')` should return `sectionsection`.

```js
assert.equal(stripTags('<main id="main"><section class="section">section</section><section class="section">section</section></main>'), "sectionsection");
```

# --seed--

## --seed-contents--

```js
function stripTags(html) {

  return html;
}
```

# --solutions--

```js
function stripTags(html) {
  return html.replace(/<[^>]*>/g, '');
}
```
