---
id: 68cae5b538ff798bbd4da001
title: "Challenge 63: Battle of Words"
challengeType: 28
dashedName: challenge-63
---

# --description--

Given two sentences representing your team and an opposing team, where each word from your team battles the corresponding word from the opposing team, determine which team wins using the following rules:

- The given sentences will always contain the same number of words.
- Words are separated by a single space and will only contain letters.
- The value of each word is the sum of its letters.
- Letters `a` to `z` correspond to the values `1` through `26`. For example, `a` is `1`, and `z` is `26`.
- A capital letter doubles the value of the letter. For example, `A` is `2`, and `Z` is `52`.
- Words battle in order: the first word of your team battles the first word of the opposing team, and so on.
- A word wins if its value is greater than the opposing word's value.
- The team with more winning words is the winner.

Return `"We win"` if your team is the winner, `"We lose"` if your team loses, and `"Draw"` if both teams have the same number of wins.

# --hints--

`battle("hello world", "hello word")` should return `"We win"`.

```js
assert.equal(battle("hello world", "hello word"), "We win");
```

`battle("Hello world", "hello world")` should return `"We win"`.

```js
assert.equal(battle("Hello world", "hello world"), "We win");
```

`battle("lorem ipsum", "kitty ipsum")` should return `"We lose"`.

```js
assert.equal(battle("lorem ipsum", "kitty ipsum"), "We lose");
```

`battle("hello world", "world hello")` should return `"Draw"`.

```js
assert.equal(battle("hello world", "world hello"), "Draw");
```

`battle("git checkout", "git switch")` should return `"We win"`.

```js
assert.equal(battle("git checkout", "git switch"), "We win");
```

`battle("Cheeseburger with fries", "Cheeseburger with Fries")` should return `"We lose"`.

```js
assert.equal(battle("Cheeseburger with fries", "Cheeseburger with Fries"), "We lose");
```

`battle("We must never surrender", "Our team must win")` should return `"Draw"`.

```js
assert.equal(battle("We must never surrender", "Our team must win"), "Draw");
```

# --seed--

## --seed-contents--

```js
function battle(ourTeam, opponent) {

  return ourTeam;
}
```

# --solutions--

```js
function getCharacterValue(char) {
  const lowerCaseValue = char.toLowerCase().charCodeAt(0) - 96;
  return char >= 'A' && char <= 'Z' ? lowerCaseValue * 2 : lowerCaseValue;
}

function getWordValue(word) {
  let wordValue = 0;
  for (let i=0; i<word.length; i++) {
    wordValue += getCharacterValue(word[i])
  }

  return wordValue;
}

function battle(ourTeam, opponent) {
  const myWords = ourTeam.split(' ');
  const opponentWords = opponent.split(' ');

  let myWins = 0, opponentWins = 0;

  for (let i=0; i<myWords.length; i++) {
    const myWordValue = getWordValue(myWords[i]);
    const opponentWordValue = getWordValue(opponentWords[i])

    if (myWordValue > opponentWordValue) myWins++;
    if (opponentWordValue > myWordValue) opponentWins++;
  }

  if (myWins > opponentWins) return 'We win';
  if (opponentWins > myWins) return 'We lose';
  return 'Draw';
}
```
