---
id: 68c1a929005bf54d342aa8d5
title: "Challenge 58: Space Week Day 4: Landing Spot"
challengeType: 28
dashedName: challenge-58
---

# --description--

In day four of Space Week, you are given a matrix of numbers (an array of arrays), representing potential landing spots for your rover. Find the safest landing spot based on the following rules:

- Each spot in the matrix will contain a number from `0-9`, inclusive.
- Any `0` represents a potential landing spot.
- Any number other than `0` is too dangerous to land. The higher the number, the more dangerous.
- The safest spot is defined as the `0` cell whose surrounding cells (up to 4 neighbors, ignore diagonals) have the lowest total danger.
- Ignore out-of-bounds neighbors (corners and edges just have fewer neighbors).
- Return the indices of the safest landing spot. There will always only be one safest spot.

For instance, given:

```js
[
  [1, 0],
  [2, 0]
]
```

Return `[0, 1]`, the indices for the `0` in the first array.

# --hints--

`findLandingSpot([[1, 0], [2, 0]])` should return `[0, 1]`.

```js
assert.deepEqual(findLandingSpot([[1, 0], [2, 0]]), [0, 1]);
```

`findLandingSpot([[9, 0, 3], [7, 0, 4], [8, 0, 5]])` should return `[1, 1]`.

```js
assert.deepEqual(findLandingSpot([[9, 0, 3], [7, 0, 4], [8, 0, 5]]), [1, 1]);
```

`findLandingSpot([[1, 2, 1], [0, 0, 2], [3, 0, 0]])` should return `[2, 2]`.

```js
assert.deepEqual(findLandingSpot([[1, 2, 1], [0, 0, 2], [3, 0, 0]]), [2, 2]);
```

`findLandingSpot([[9, 6, 0, 8], [7, 1, 1, 0], [3, 0, 3, 9], [8, 6, 0, 9]])` should return `[2, 1]`.

```js
assert.deepEqual(findLandingSpot([[9, 6, 0, 8], [7, 1, 1, 0], [3, 0, 3, 9], [8, 6, 0, 9]]), [2, 1]);
```

# --seed--

## --seed-contents--

```js
function findLandingSpot(matrix) {

  return matrix;
}
```

# --solutions--

```js
function findLandingSpot(matrix) {
  let bestSpot = null;
  let lowestNeighborSum = Infinity;

  for (let i = 0; i < matrix.length; i++) {
    for (let j = 0; j < matrix[i].length; j++) {

      if (matrix[i][j] === 0) {
        let currentNeighborSum = 0;

        if (i > 0) currentNeighborSum += matrix[i - 1][j];
        if (j < matrix[i].length - 1) currentNeighborSum += matrix[i][j + 1];
        if (i < matrix.length - 1) currentNeighborSum += matrix[i + 1][j];
        if (j > 0) currentNeighborSum += matrix[i][j - 1];

        if (currentNeighborSum < lowestNeighborSum) {
          lowestNeighborSum = currentNeighborSum;
          bestSpot = [i, j];
        }
      }
    }
  }

  return bestSpot;
}
```
