---
id: 68c1a929005bf54d342aa8d4
title: "Challenge 57: Space Week Day 3: Phone Home"
challengeType: 28
dashedName: challenge-57
---

# --description--

For day three of Space Week, you are given an array of numbers representing distances (in kilometers) between yourself, satellites, and your home planet in a communication route. Determine how long it will take a message sent through the route to reach its destination planet using the following constraints:

- The first value in the array is the distance from your location to the first satellite.
- Each subsequent value, except for the last, is the distance to the next satellite.
- The last value in the array is the distance from the previous satellite to your home planet.
- The message travels at 300,000 km/s.
- Each satellite the message **passes through** adds a 0.5 second transmission delay.
- Return a number rounded to 4 decimal places, with trailing zeros removed.

# --hints--

`sendMessage([300000, 300000])` should return `2.5`.

```js
assert.equal(sendMessage([300000, 300000]), 2.5);
```

`sendMessage([384400, 384400])` should return `3.0627`.

```js
assert.equal(sendMessage([384400, 384400]), 3.0627);
```

`sendMessage([54600000, 54600000])` should return `364.5`.

```js
assert.equal(sendMessage([54600000, 54600000]), 364.5);
```

`sendMessage([1000000, 500000000, 1000000])` should return `1674.3333`.

```js
assert.equal(sendMessage([1000000, 500000000, 1000000]), 1674.3333);
```

`sendMessage([10000, 21339, 50000, 31243, 10000])` should return `2.4086`.

```js
assert.equal(sendMessage([10000, 21339, 50000, 31243, 10000]), 2.4086);
```

`sendMessage([802101, 725994, 112808, 3625770, 481239])` should return `21.1597`.

```js
assert.equal(sendMessage([802101, 725994, 112808, 3625770, 481239]), 21.1597);
```

# --seed--

## --seed-contents--

```js
function sendMessage(route) {

  return route;
}
```

# --solutions--

```js
function sendMessage(route) {
  let totalDistance = route.reduce((a, d) => a += d, 0);

  const delay = (route.length - 1) * 0.5
  const time = totalDistance / 300000
  const total = time + delay;
  return Number(total.toFixed(4))
}
```
