---
id: 68c1a929005bf54d342aa8d3
title: "Challenge 56: Space Week Day 2: Exoplanet Search"
challengeType: 28
dashedName: challenge-56
---

# --description--

For the second day of Space Week, you are given a string where each character represents the luminosity reading of a star. Determine if the readings have detected an exoplanet using the transit method. The transit method is when a planet passes in front of a star, reducing its observed luminosity.

- Luminosity readings only comprise of characters `0-9` and `A-Z` where each reading corresponds to the following numerical values:
- Characters `0-9` correspond to luminosity levels `0-9`.
- Characters `A-Z` correspond to luminosity levels `10-35`.

A star is considered to have an exoplanet if any single reading is less than or equal to 80% of the average of all readings. For example, if the average luminosity of a star is 10, it would be considered to have a exoplanet if any single reading is 8 or less.

# --hints--

`hasExoplanet("665544554")` should return `false`.

```js
assert.isFalse(hasExoplanet("665544554"));
```

`hasExoplanet("FGFFCFFGG")` should return `true`.

```js
assert.isTrue(hasExoplanet("FGFFCFFGG"));
```

`hasExoplanet("MONOPLONOMONPLNOMPNOMP")` should return `false`.

```js
assert.isFalse(hasExoplanet("MONOPLONOMONPLNOMPNOMP"));
```

`hasExoplanet("FREECODECAMP")` should return `true`.

```js
assert.isTrue(hasExoplanet("FREECODECAMP"));
```

`hasExoplanet("9AB98AB9BC98A")` should return `false`.

```js
assert.isFalse(hasExoplanet("9AB98AB9BC98A"));
```

`hasExoplanet("ZXXWYZXYWYXZEGZXWYZXYGEE")` should return `true`.

```js
assert.isTrue(hasExoplanet("ZXXWYZXYWYXZEGZXWYZXYGEE"));
```

# --seed--

## --seed-contents--

```js
function hasExoplanet(readings) {

  return readings;
}
```

# --solutions--

```js
function hasExoplanet(readings) {
  let total = 0;
  const values = readings.split('').map(c => parseInt(c, 36));
  
  total = values.reduce((sum, v) => sum + v, 0);
  const average = total / values.length;
  const threshold = average * 0.8;

  return values.some(v => v <= threshold);
}
```
