---
id: 68b1f72371a5ac895ac70a08
title: "Challenge 43: Digits vs Letters"
challengeType: 28
dashedName: challenge-43
---

# --description--

Given a string, return `"digits"` if the string has more digits than letters, `"letters"` if it has more letters than digits, and `"tie"` if it has the same amount of digits and letters.

- Digits consist of `0-9`.
- Letters consist of `a-z` in upper or lower case.
- Ignore any other characters.

# --hints--

`digitsOrLetters("abc123")` should return `"tie"`.

```js
assert.equal(digitsOrLetters("abc123"), "tie");
```

`digitsOrLetters("a1b2c3d")` should return `"letters"`.

```js
assert.equal(digitsOrLetters("a1b2c3d"), "letters");
```

`digitsOrLetters("1a2b3c4")` should return `"digits"`.

```js
assert.equal(digitsOrLetters("1a2b3c4"), "digits");
```

`digitsOrLetters("abc123!@#DEF")` should return `"letters"`.

```js
assert.equal(digitsOrLetters("abc123!@#DEF"), "letters");
```

`digitsOrLetters("H3110 W0R1D")` should return `"digits"`.

```js
assert.equal(digitsOrLetters("H3110 W0R1D"), "digits");
```

`digitsOrLetters("P455W0RD")` should return `"tie"`.

```js
assert.equal(digitsOrLetters("P455W0RD"), "tie");
```

# --seed--

## --seed-contents--

```js
function digitsOrLetters(str) {

  return str;
}
```

# --solutions--

```js
function digitsOrLetters(str) {
  let digitCount = 0;
  let letterCount = 0;

  for (let char of str) {
    if (/[0-9]/.test(char)) digitCount++;
    else if (/[a-zA-Z]/.test(char)) letterCount++;
  }

  if (digitCount > letterCount) return "digits";
  if (letterCount > digitCount) return "letters";
  return "tie";
}
```
