---
id: 68b1f72371a5ac895ac70a04
title: "Challenge 41: File Storage"
challengeType: 28
dashedName: challenge-41
---

# --description--

Given a file size, a unit for the file size, and hard drive capacity in gigabytes (GB), return the number of files the hard drive can store using the following constraints:

- The unit for the file size can be bytes (`"B"`), kilobytes (`"KB"`), or megabytes (`"MB"`).
- Return the number of whole files the drive can fit.
- Use the following conversions:

| Unit | Equivalent |
|:----:|:----------:|
| 1 B  |   1 B      |
| 1 KB |   1000 B   |
| 1 MB |   1000 KB  |
| 1 GB |   1000 MB  |

For example, given `500`, `"KB"`, and `1` as arguments, determine how many 500 KB files can fit on a 1 GB hard drive.

# --hints--

`numberOfFiles(500, "KB", 1)` should return `2000`.

```js
assert.equal(numberOfFiles(500, "KB", 1), 2000);
```

`numberOfFiles(50000, "B", 1)` should return `20000`.

```js
assert.equal(numberOfFiles(50000, "B", 1), 20000);
```

`numberOfFiles(5, "MB", 1)` should return `200`.

```js
assert.equal(numberOfFiles(5, "MB", 1), 200);
```

`numberOfFiles(4096, "B", 1.5)` should return `366210`.

```js
assert.equal(numberOfFiles(4096, "B", 1.5), 366210);
```

`numberOfFiles(220.5, "KB", 100)` should return `453514`.

```js
assert.equal(numberOfFiles(220.5, "KB", 100), 453514);
```

`numberOfFiles(4.5, "MB", 750)` should return `166666`.

```js
assert.equal(numberOfFiles(4.5, "MB", 750), 166666);
```

# --seed--

## --seed-contents--

```js
function numberOfFiles(fileSize, fileUnit, driveSizeGb) {

  return fileSize;
}
```

# --solutions--

```js
function numberOfFiles(fileSize, fileUnit, driveSizeGb) {
  const driveSizeBytes = driveSizeGb * 1000 * 1000 * 1000;

  let fileSizeBytes;
  if (fileUnit === "B") {
    fileSizeBytes = fileSize;
  } else if (fileUnit === "KB") {
    fileSizeBytes = fileSize * 1000;
  } else {
    fileSizeBytes = fileSize * 1000 * 1000;
  }

  return Math.floor(driveSizeBytes / fileSizeBytes);
}
```
