---
id: 68b06e589bf2273243814773
title: "Challenge 37: Sentence Capitalizer"
challengeType: 28
dashedName: challenge-37
---

# --description--

Given a paragraph, return a new paragraph where the first letter of each sentence is capitalized.

- All other characters should be preserved.
- Sentences can end with a period (`.`), one or more question marks (`?`), or one or more exclamation points (`!`).

# --hints--

`capitalize("this is a simple sentence.")` should return `"This is a simple sentence."`.

```js
assert.equal(capitalize("this is a simple sentence."), "This is a simple sentence.");
```

`capitalize("hello world. how are you?")` should return `"Hello world. How are you?"`.

```js
assert.equal(capitalize("hello world. how are you?"), "Hello world. How are you?");
```

`capitalize("i did today's coding challenge... it was fun!!")` should return `"I did today's coding challenge... It was fun!!"`.

```js
assert.equal(capitalize("i did today's coding challenge... it was fun!!"), "I did today's coding challenge... It was fun!!");
```

`capitalize("crazy!!!strange???unconventional...sentences.")` should return `"Crazy!!!Strange???Unconventional...Sentences."`.

```js
assert.equal(capitalize("crazy!!!strange???unconventional...sentences."), "Crazy!!!Strange???Unconventional...Sentences.");
```

`capitalize("there's a space before this period . why is there a space before that period ?")` should return `"There's a space before this period . Why is there a space before that period ?"`.

```js
assert.equal(capitalize("there's a space before this period . why is there a space before that period ?"), "There's a space before this period . Why is there a space before that period ?");
```

# --seed--

## --seed-contents--

```js
function capitalize(paragraph) {

  return paragraph;
}
```

# --solutions--

```js
function capitalize(paragraph) {
  return paragraph.replace(/([.!?]+)(\s*)([a-z])/g, (match, punc, spaces, char) => {
    return punc + spaces + char.toUpperCase();
  })
  .replace(/^([a-z])/, (match, char) => char.toUpperCase());
}
```
