---
id: 68af0687ef34c76c28ffa54d
title: "Challenge 33: Screen Time"
challengeType: 28
dashedName: challenge-33
---

# --description--

Given an input array of seven integers, representing a week's time, where each integer is the amount of hours spent on your phone that day, determine if it is too much screen time based on these constraints:

- If any single day has 10 hours or more, it's too much.
- If the average of any three days in a row is greater than or equal to 8 hours, it’s too much.
- If the average of the seven days is greater than or equal to 6 hours, it's too much.

# --hints--

`tooMuchScreenTime([1, 2, 3, 4, 5, 6, 7])` should return `false`.

```js
assert.isFalse(tooMuchScreenTime([1, 2, 3, 4, 5, 6, 7]));
```

`tooMuchScreenTime([7, 8, 8, 4, 2, 2, 3])` should return `false`.

```js
assert.isFalse(tooMuchScreenTime([7, 8, 8, 4, 2, 2, 3]));
```

`tooMuchScreenTime([5, 6, 6, 6, 6, 6, 6])` should return `false`.

```js
assert.isFalse(tooMuchScreenTime([5, 6, 6, 6, 6, 6, 6]));
```

`tooMuchScreenTime([1, 2, 3, 11, 1, 3, 4])` should return `true`.

```js
assert.isTrue(tooMuchScreenTime([1, 2, 3, 11, 1, 3, 4]));
```

`tooMuchScreenTime([1, 2, 3, 10, 2, 1, 0])` should return `true`.

```js
assert.isTrue(tooMuchScreenTime([1, 2, 3, 10, 2, 1, 0]));
```

`tooMuchScreenTime([3, 3, 5, 8, 8, 9, 4])` should return `true`.

```js
assert.isTrue(tooMuchScreenTime([3, 3, 5, 8, 8, 9, 4]));
```

`tooMuchScreenTime([3, 9, 4, 8, 5, 7, 6])` should return `true`.

```js
assert.isTrue(tooMuchScreenTime([3, 9, 4, 8, 5, 7, 6]));
```

# --seed--

## --seed-contents--

```js
function tooMuchScreenTime(hours) {

  return hours;
}
```

# --solutions--

```js
function tooMuchScreenTime(hours) {
  for (let h of hours) {
    if (h >= 10) return true;
  }

  for (let i = 0; i <= 4; i++) {
    const avg3 = (hours[i] + hours[i+1] + hours[i+2]) / 3;
    if (avg3 >= 8) return true;
  }

  const weeklyAvg = hours.reduce((sum, h) => sum + h, 0) / 7;
  if (weeklyAvg >= 6) return true;

  return false;
}
```
