---
id: 68adce01c0e1144d0a902958
title: "Challenge 26: IPv4 Validator"
challengeType: 28
dashedName: challenge-26
---

# --description--

Given a string, determine if it is a valid IPv4 Address. A valid IPv4 address consists of four integer numbers separated by dots (`.`). Each number must satisfy the following conditions:

- It is between 0 and 255 inclusive.
- It does not have leading zeros (e.g. 0 is allowed, 01 is not).
- Only numeric characters are allowed.

# --hints--

`isValidIPv4("192.168.1.1")` should return `true`.

```js
assert.isTrue(isValidIPv4("192.168.1.1"));
```

`isValidIPv4("0.0.0.0")` should return `true`.

```js
assert.isTrue(isValidIPv4("0.0.0.0"));
```

`isValidIPv4("255.01.50.111")` should return `false`.

```js
assert.isFalse(isValidIPv4("255.01.50.111"));
```

`isValidIPv4("255.00.50.111")` should return `false`.

```js
assert.isFalse(isValidIPv4("255.00.50.111"));
```

`isValidIPv4("256.101.50.115")` should return `false`.

```js
assert.isFalse(isValidIPv4("256.101.50.115"));
```

`isValidIPv4("192.168.101.")` should return `false`.

```js
assert.isFalse(isValidIPv4("192.168.101."));
```

`isValidIPv4("192168145213")` should return `false`.

```js
assert.isFalse(isValidIPv4("192168145213"));
```

# --seed--

## --seed-contents--

```js
function isValidIPv4(ipv4) {

  return ipv4;
}
```

# --solutions--

```js
function isValidIPv4(ipv4) {
  const parts = ipv4.split(".");
  
  if (parts.length !== 4) return false;

  for (let part of parts) {
    if (!/^\d+$/.test(part)) return false;    

    const num = Number(part);
    if (num < 0 || num > 255) return false;

    if (part.length > 1 && part.startsWith("0")) return false;
  }

  return true;
}
```
