import React from 'react';

const TencentLogo = (
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element => (
  <svg
    height='75'
    id='tencent-logo'
    version='1.1'
    viewBox='0 0 1000 190'
    width='100'
    xmlns='http://www.w3.org/2000/svg'
    role='img'
    aria-labelledby='tencent-logo-label'
    {...props}
  >
    <title id='tencent-logo-label'>Tencent</title>
    <g fill='none'>
      <g fill='var(--quaternary-color)'>
        <polygon
          id='Path'
          points='918.94 58.881 876.21 58.881 893.02 82.992 914.68 82.992 896.46 186.71 934.42 186.71 952.66 82.992 1e3 82.992 925.27 22.869'
        />
        <polygon
          id='Path'
          points='177.14 0 4.709 0 0 27.159 66.949 27.159 38.9 186.72 76.854 186.72 104.91 27.159 172.43 27.159'
        />
        <path
          d='m119.96 121.65c-6.796 39.169 17.271 67.841 65.96 67.841 21.754 0 42.106-4.092 58.643-13.282l5.135-29.215c-16.153 11.573-36.711 18.04-54.126 18.04-24.272 0-43.568-10.105-40.533-33.286h100.3c1.208-2.753 2.656-7.572 3.7-13.584 4.86-27.988-5.06-62.156-53.818-62.156-48.243 0-79.126 30.365-85.256 65.642zm104.93-12.438h-66.008c3.968-13.075 16.791-31.152 40.136-31.152 25.404 0 28.089 19.313 25.872 31.152'
          id='a'
        />
        <path
          d='m372.83 56.011c-23.689 0-41.434 9.819-49.801 19.745h-0.885l-33.409-19.745c-1.229 11.079-2.869 26.123-5.437 40.889l-15.603 89.813h37.953l13.2-75.214c0.632-3.692 1.888-7.605 3.521-10.262 5.67-9.868 17.566-18.956 32.647-18.956 20.71 0 26.346 13.973 23.167 32.308l-12.692 72.124h37.96l13.365-75.927c7.017-40.422-17.839-54.775-43.986-54.775'
          id='Path'
        />
        <path
          d='m828.13 56.011c-23.702 0-41.425 9.819-49.794 19.745h-0.884l-33.41-19.745c-1.229 11.079-2.877 26.123-5.444 40.889l-15.588 89.813h37.939l13.207-75.214c0.625-3.692 1.882-7.605 3.508-10.262 5.676-9.868 17.571-18.956 32.641-18.956 20.735 0 26.365 13.973 23.188 32.308l-12.686 72.124h37.953l13.345-75.927c7.02-40.422-17.829-54.775-43.975-54.775'
          id='b'
        />
        <path d='m660.51 56.004c-48.243 0-79.118 30.365-85.249 65.642-6.796 39.169 17.271 67.841 65.953 67.841 21.753 0 42.113-4.092 58.643-13.282l5.142-29.215c-16.151 11.573-36.704 18.04-54.14 18.04-24.259 0-43.533-10.105-40.521-33.286h100.31c1.188-2.753 2.643-7.572 3.706-13.584 4.833-27.988-5.092-62.156-53.843-62.156m19.673 53.204h-66c3.96-13.075 16.783-31.152 40.121-31.152 25.419 0 28.103 19.313 25.879 31.152' />
        <path d='m432.75 121.08c-6.885 39.678 20.896 68.391 67.916 68.391 18.699 0 41.021-5.376 49.479-8.512l6.137-34.165c-13.186 14.183-31.062 17.128-43.747 17.128-25.83 0-45.387-15.04-40.836-41.249 3.947-23.435 26.14-41.445 55.073-41.445 11.779 0 27.767 3.945 37.844 17.207l5.883-34.752c-8.162-3.133-21.225-7.605-40.563-7.605-52.76 0-90.534 26.733-97.186 65.002' />
      </g>
    </g>
  </svg>
);

TencentLogo.displayName = 'TencentLogo';
export default TencentLogo;
