import React from 'react';

const SpotifyLogo = (
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element => (
  <svg
    id='spotify-logo'
    viewBox='3018 235.379 1525 572'
    xmlns='http://www.w3.org/2000/svg'
    xmlnsXlink='http://www.w3.org/1999/xlink'
    fill='var(--quaternary-color)'
    role='img'
    aria-labelledby='spotify-logo-label'
    {...props}
  >
    <title id='spotify-logo-label'>Spotify</title>
    <path d=' M 3254.79 285.379 C 3124.017 285.379 3018 391.394 3018 522.167 C 3018 652.946 3124.017 758.952 3254.79 758.952 C 3385.578 758.952 3491.584 652.946 3491.584 522.167 C 3491.584 391.402 3385.578 285.391 3254.788 285.391 L 3254.79 285.379 L 3254.79 285.379 Z  M 3363.381 626.895 C 3359.14 633.851 3350.035 636.056 3343.079 631.787 C 3287.483 597.827 3217.495 590.136 3135.071 608.968 C 3127.128 610.778 3119.211 605.801 3117.401 597.856 C 3115.583 589.91 3120.54 581.993 3128.502 580.183 C 3218.702 559.576 3296.073 568.449 3358.489 606.593 C 3365.445 610.863 3367.651 619.939 3363.381 626.895 L 3363.381 626.895 Z  M 3392.364 562.42 C 3387.02 571.107 3375.653 573.85 3366.972 568.505 C 3303.323 529.383 3206.3 518.053 3131.016 540.905 C 3121.252 543.854 3110.94 538.352 3107.977 528.605 C 3105.036 518.842 3110.541 508.549 3120.288 505.58 C 3206.283 479.487 3313.191 492.127 3386.285 537.043 C 3394.965 542.387 3397.708 553.754 3392.364 562.423 L 3392.364 562.42 Z  M 3394.852 495.282 C 3318.536 449.953 3192.623 445.785 3119.759 467.9 C 3108.059 471.449 3095.685 464.843 3092.139 453.143 C 3088.593 441.437 3095.193 429.071 3106.902 425.514 C 3190.545 400.123 3329.591 405.029 3417.456 457.189 C 3428.003 463.435 3431.452 477.027 3425.203 487.537 C 3418.983 498.062 3405.354 501.531 3394.863 495.282 L 3394.852 495.282 Z  M 3662.229 503.969 C 3621.342 494.219 3614.075 487.376 3614.075 472.998 C 3614.075 459.414 3626.855 450.273 3645.885 450.273 C 3664.321 450.273 3682.587 457.214 3701.758 471.505 C 3702.324 471.938 3703.059 472.11 3703.766 471.997 C 3704.501 471.89 3705.123 471.497 3705.547 470.906 L 3725.51 442.765 C 3726.33 441.606 3726.104 440.009 3725.001 439.124 C 3702.182 420.821 3676.508 411.922 3646.479 411.922 C 3602.34 411.922 3571.491 438.414 3571.491 476.318 C 3571.491 516.964 3598.099 531.357 3644.075 542.466 C 3683.181 551.478 3689.798 559.027 3689.798 572.521 C 3689.798 587.478 3676.451 596.781 3654.962 596.781 C 3631.097 596.781 3611.615 588.723 3589.842 569.891 C 3589.305 569.41 3588.57 569.212 3587.891 569.241 C 3587.156 569.297 3586.506 569.636 3586.053 570.174 L 3563.659 596.81 C 3562.726 597.941 3562.839 599.581 3563.913 600.542 C 3589.249 623.163 3620.409 635.095 3654.057 635.095 C 3701.617 635.095 3732.353 609.109 3732.353 568.873 C 3732.438 534.922 3712.107 516.119 3662.313 504.005 L 3662.229 503.969 L 3662.229 503.969 Z  M 3839.971 463.647 C 3819.358 463.647 3802.449 471.768 3788.48 488.408 L 3788.48 469.678 C 3788.48 468.2 3787.293 466.995 3785.822 466.995 L 3749.205 466.995 C 3747.735 466.995 3746.547 468.2 3746.547 469.678 L 3746.547 677.792 C 3746.547 679.262 3747.735 680.478 3749.205 680.478 L 3785.822 680.478 C 3787.293 680.478 3788.48 679.262 3788.48 677.792 L 3788.48 612.107 C 3802.449 627.743 3819.358 635.406 3839.971 635.406 C 3878.284 635.406 3917.079 605.914 3917.079 549.535 C 3917.135 493.145 3878.341 463.644 3839.999 463.644 L 3839.971 463.647 Z  M 3874.495 549.535 C 3874.495 578.232 3856.823 598.28 3831.488 598.28 C 3806.464 598.28 3787.575 577.327 3787.575 549.535 C 3787.575 521.74 3806.464 500.793 3831.488 500.793 C 3856.399 500.79 3874.495 521.285 3874.495 549.532 L 3874.495 549.535 Z  M 4016.468 463.647 C 3967.127 463.647 3928.474 501.639 3928.474 550.149 C 3928.474 598.138 3966.873 635.717 4015.875 635.717 C 4065.386 635.717 4104.152 597.856 4104.152 549.535 C 4104.152 501.378 4065.64 463.653 4016.468 463.653 L 4016.468 463.647 L 4016.468 463.647 Z  M 4016.468 598.563 C 3990.228 598.563 3970.435 577.469 3970.435 549.521 C 3970.435 521.446 3989.55 501.073 4015.875 501.073 C 4042.284 501.073 4062.191 522.158 4062.191 550.135 C 4062.191 578.204 4042.963 598.563 4016.468 598.563 L 4016.468 598.563 Z  M 4209.508 466.995 L 4169.215 466.995 L 4169.215 425.808 C 4169.215 424.332 4168.027 423.128 4166.557 423.128 L 4129.939 423.128 C 4128.469 423.128 4127.253 424.332 4127.253 425.808 L 4127.253 466.995 L 4109.666 466.995 C 4108.195 466.995 4107.008 468.2 4107.008 469.678 L 4107.008 501.141 C 4107.008 502.617 4108.195 503.824 4109.666 503.824 L 4127.253 503.824 L 4127.253 585.245 C 4127.253 618.13 4143.625 634.812 4175.944 634.812 C 4189.064 634.812 4199.951 632.098 4210.215 626.273 C 4211.063 625.821 4211.572 624.916 4211.572 623.954 L 4211.572 593.982 C 4211.572 593.077 4211.091 592.201 4210.299 591.72 C 4209.508 591.211 4208.518 591.183 4207.698 591.607 C 4200.657 595.141 4193.843 596.781 4186.208 596.781 C 4174.474 596.781 4169.215 591.437 4169.215 579.505 L 4169.215 503.839 L 4209.508 503.839 C 4210.978 503.839 4212.166 502.634 4212.166 501.155 L 4212.166 469.695 C 4212.222 468.217 4211.035 467.012 4209.536 467.012 L 4209.508 466.995 L 4209.508 466.995 Z  M 4349.869 467.156 L 4349.869 462.098 C 4349.869 447.216 4355.581 440.58 4368.361 440.58 C 4375.996 440.58 4382.132 442.095 4389.003 444.386 C 4389.851 444.651 4390.728 444.519 4391.406 444.012 C 4392.113 443.506 4392.509 442.695 4392.509 441.835 L 4392.509 410.986 C 4392.509 409.807 4391.774 408.764 4390.615 408.416 C 4383.376 406.259 4374.101 404.045 4360.19 404.045 C 4326.4 404.045 4308.501 423.085 4308.501 459.089 L 4308.501 466.837 L 4290.914 466.837 C 4289.444 466.837 4288.228 468.041 4288.228 469.517 L 4288.228 501.141 C 4288.228 502.617 4289.444 503.824 4290.914 503.824 L 4308.501 503.824 L 4308.501 629.383 C 4308.501 630.882 4309.717 632.069 4311.188 632.069 L 4347.777 632.069 C 4349.275 632.069 4350.463 630.882 4350.463 629.383 L 4350.463 503.833 L 4384.648 503.833 L 4437.015 629.383 C 4431.077 642.56 4425.224 645.189 4417.25 645.189 C 4410.803 645.189 4403.989 643.267 4397.061 639.449 C 4396.411 639.11 4395.619 639.054 4394.941 639.252 C 4394.234 639.506 4393.64 640.015 4393.357 640.694 L 4380.944 667.923 C 4380.35 669.224 4380.859 670.723 4382.104 671.401 C 4395.054 678.414 4406.732 681.411 4421.181 681.411 C 4448.212 681.411 4463.17 668.8 4476.319 634.925 L 4539.826 470.821 C 4540.166 469.995 4540.052 469.062 4539.543 468.33 C 4539.063 467.603 4538.243 467.165 4537.366 467.165 L 4499.25 467.165 C 4498.091 467.165 4497.073 467.891 4496.706 468.963 L 4457.657 580.466 L 4414.904 468.89 C 4414.508 467.852 4413.518 467.165 4412.415 467.165 L 4349.869 467.165 L 4349.869 467.156 L 4349.869 467.156 Z  M 4268.491 466.995 L 4231.874 466.995 C 4230.404 466.995 4229.188 468.2 4229.188 469.678 L 4229.188 629.383 C 4229.188 630.882 4230.404 632.069 4231.874 632.069 L 4268.491 632.069 C 4269.961 632.069 4271.177 630.882 4271.177 629.383 L 4271.177 469.69 C 4271.177 468.211 4269.99 467.006 4268.491 467.006 L 4268.491 466.995 Z  M 4250.395 394.272 C 4235.889 394.272 4224.126 406.013 4224.126 420.515 C 4224.126 435.026 4235.889 446.781 4250.395 446.781 C 4264.9 446.781 4276.635 435.026 4276.635 420.515 C 4276.635 406.015 4264.872 394.272 4250.395 394.272 Z  M 4571.099 518.347 C 4556.622 518.347 4545.34 506.711 4545.34 492.582 C 4545.34 478.452 4556.764 466.684 4571.241 466.684 C 4585.718 466.684 4597 478.317 4597 492.435 C 4597 506.564 4585.577 518.347 4571.099 518.347 Z  M 4571.241 469.246 C 4558.036 469.246 4548.055 479.736 4548.055 492.582 C 4548.055 505.422 4557.979 515.771 4571.099 515.771 C 4584.304 515.771 4594.285 505.289 4594.285 492.435 C 4594.285 479.595 4584.361 469.246 4571.241 469.246 L 4571.241 469.246 Z  M 4576.953 495.084 L 4584.248 505.286 L 4578.083 505.286 L 4571.523 495.927 L 4565.897 495.927 L 4565.897 505.286 L 4560.75 505.286 L 4560.75 478.243 L 4572.796 478.243 C 4579.101 478.243 4583.23 481.458 4583.23 486.87 C 4583.258 491.304 4580.685 494.013 4576.981 495.084 L 4576.953 495.084 Z  M 4572.598 482.883 L 4565.897 482.883 L 4565.897 491.437 L 4572.598 491.437 C 4575.934 491.437 4577.942 489.8 4577.942 487.156 C 4577.942 484.373 4575.934 482.883 4572.598 482.883 L 4572.598 482.883 Z ' />
  </svg>
);

SpotifyLogo.displayName = 'SpotifyLogo';

export default SpotifyLogo;
