import React from 'react';

function SupporterBadge(
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      width='304'
      height='347'
      viewBox='0 0 304 347'
      fill='currentColor'
      {...props}
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M0.5 -0.5V261L147.5 347L303.5 261V-0.5H0.5ZM68.625 61.9398C68.6211 60.616 67.7036 59.3001 66.786 58.3863C65.4624 57.4725 64.088 57.0196 62.7683 57.0235C58.7037 57.0313 52.7454 61.2369 45.6002 69.3319C25.7459 91.9846 15.602 113.927 16.012 146.283C16.4571 178.624 24.3832 202.354 41.9144 223.843C50.9181 235.179 57.8135 241.006 62.7409 240.994C64.0607 240.994 65.8919 240.072 66.7509 239.155C67.6645 237.831 68.5742 236.456 68.5742 235.136C68.5664 232.442 66.7274 229.295 62.249 225.292C40.9539 205.01 29.9979 178.839 29.9198 146.252C29.8495 116.797 40.2667 92.3751 60.9761 72.4324C65.9426 67.3326 68.6289 64.2281 68.625 61.9398ZM175.561 152.082C173.541 151.566 174.198 148.64 175.284 143.8C178.383 129.999 184.975 100.635 142.959 67.192C142.959 67.192 150.405 90.8522 112.859 143.651C77.276 193.646 124.091 224.496 129.131 227.612C129.406 227.79 129.562 227.873 129.562 227.873C129.562 227.873 129.411 227.786 129.131 227.612C125.903 225.528 106.418 210.506 133.701 165.972C135.302 163.323 137.052 160.75 138.953 157.956C143.343 151.502 148.535 143.868 154.543 131.397C154.543 131.397 162.165 142.156 158.186 165.48C152.921 196.666 177.176 192.362 183.174 191.297H183.174C183.955 191.158 184.426 191.075 184.483 191.132C195.372 203.954 176.028 226.313 174.149 227.811C174.05 227.877 174.019 227.898 174.062 227.873C174.085 227.86 174.114 227.839 174.149 227.811L174.157 227.805C176.973 225.931 230.459 190.319 189.957 137.684C189.149 138.492 188.273 140.138 187.259 142.044C184.661 146.926 181.156 153.514 175.561 152.082ZM236.132 61.9164C236.136 60.5926 237.053 59.2766 237.971 58.3629C239.294 57.4491 240.669 56.9961 241.988 57C246.053 57.0078 252.011 61.2135 259.157 69.3085C279.011 91.9611 289.155 113.903 288.745 146.26C288.3 178.6 280.374 202.331 262.842 223.82C253.839 235.156 246.943 240.982 242.016 240.97C240.696 240.967 238.865 240.049 238.006 239.131C237.092 237.807 236.182 236.433 236.182 235.113C236.19 232.419 238.029 229.271 242.508 225.269C263.803 204.986 274.759 178.815 274.837 146.228C274.907 116.773 264.49 92.3477 243.781 72.409C238.814 67.3091 236.128 64.2047 236.132 61.9164Z'
        fill='currentColor'
      />
    </svg>
  );
}

SupporterBadge.displayName = 'SupporterBadge';

export default SupporterBadge;
