import React from 'react';

function SupporterBadgeEmblem(
  props: JSX.IntrinsicAttributes & React.SVGProps<SVGSVGElement>
): JSX.Element {
  return (
    <svg
      width='560'
      height='560'
      viewBox='0 0 560 560'
      fill='none'
      {...props}
      xmlns='http://www.w3.org/2000/svg'
    >
      <path
        fillRule='evenodd'
        clipRule='evenodd'
        d='M170 165V354.158L276.334 416.367L389.177 354.158V165H170ZM219.279 210.167C219.276 209.209 218.612 208.257 217.948 207.596C216.991 206.935 215.997 206.608 215.042 206.61C212.102 206.616 207.792 209.658 202.624 215.514C188.262 231.9 180.924 247.772 181.221 271.177C181.543 294.571 187.276 311.737 199.957 327.281C206.47 335.481 211.458 339.695 215.022 339.687C215.977 339.687 217.302 339.02 217.923 338.356C218.584 337.399 219.242 336.405 219.242 335.45C219.236 333.501 217.906 331.224 214.667 328.329C199.263 313.657 191.337 294.726 191.281 271.154C191.23 249.848 198.766 232.182 213.746 217.757C217.338 214.068 219.282 211.822 219.279 210.167ZM296.632 275.371C295.171 274.998 295.646 272.882 296.432 269.38C298.673 259.398 303.442 238.157 273.049 213.965C273.049 213.965 278.435 231.08 251.276 269.273C225.537 305.437 259.401 327.752 263.046 330.007C263.245 330.135 263.358 330.196 263.358 330.196C263.358 330.196 263.249 330.132 263.046 330.007C260.711 328.499 246.617 317.633 266.352 285.419C267.51 283.503 268.776 281.641 270.151 279.62L270.151 279.62C273.327 274.951 277.083 269.429 281.429 260.409C281.429 260.409 286.942 268.191 284.064 285.063C280.255 307.622 297.8 304.508 302.139 303.738C302.704 303.638 303.045 303.577 303.086 303.618C310.962 312.893 296.971 329.066 295.61 330.151C295.539 330.198 295.516 330.213 295.548 330.196C295.564 330.186 295.585 330.171 295.61 330.151L295.617 330.147C297.654 328.79 336.343 303.03 307.045 264.957C306.461 265.541 305.828 266.732 305.094 268.11C303.215 271.642 300.679 276.407 296.632 275.371ZM340.446 210.149C340.449 209.192 341.113 208.24 341.776 207.579C342.734 206.918 343.728 206.59 344.683 206.593C347.623 206.599 351.933 209.641 357.101 215.496C371.463 231.882 378.801 247.754 378.504 271.16C378.182 294.554 372.449 311.719 359.768 327.264C353.255 335.464 348.267 339.678 344.703 339.67C343.748 339.667 342.423 339.003 341.802 338.339C341.141 337.382 340.483 336.387 340.483 335.433C340.489 333.483 341.819 331.207 345.058 328.312C360.462 313.64 368.387 294.709 368.444 271.137C368.495 249.831 360.959 232.162 345.979 217.739C342.387 214.05 340.443 211.805 340.446 210.149Z'
        fill='var(--primary-color)'
      />
      <circle
        cx='280'
        cy='280'
        r='277'
        stroke='var(--primary-color)'
        strokeWidth='6'
      />
      <path
        d='M179.307 84.7228C179.307 84.7228 43.708 159.054 72.0892 320.332C94.921 450.074 259.933 494.565 259.933 494.565'
        stroke='var(--primary-color)'
        strokeWidth='3'
      />
      <path
        d='M231.895 460.536C227.21 450.093 214.465 437.01 214.465 437.01C214.465 437.01 213.898 455.752 218.947 466.042C223.755 475.842 237.871 486.564 237.871 486.564C237.871 486.564 236.162 470.045 231.895 460.536Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M208.683 488.623C197.679 491.773 182.914 502.524 182.914 502.524C182.914 502.524 201.384 505.755 212.288 502.224C222.674 498.86 235.297 486.416 235.297 486.416C235.297 486.416 218.703 485.755 208.683 488.623Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M174.595 469.69C163.221 470.972 146.877 479.126 146.877 479.126C146.877 479.126 164.556 485.375 175.895 483.7C186.694 482.106 201.207 471.927 201.207 471.927C201.207 471.927 184.952 468.523 174.595 469.69Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M142.106 447.479C130.661 447.544 113.542 453.915 113.542 453.915C113.542 453.915 130.457 462.008 141.909 461.548C152.817 461.11 168.329 452.532 168.329 452.532C168.329 452.532 152.529 447.42 142.106 447.479Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M115.752 421.624C104.457 419.779 86.5155 423.205 86.5155 423.205C86.5155 423.205 101.843 434.006 113.212 435.463C124.04 436.851 140.766 430.98 140.766 430.98C140.766 430.98 126.039 423.304 115.752 421.624Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M92.1644 395.339C81.3556 391.576 63.0924 391.859 63.0924 391.859C63.0924 391.859 76.3294 405.139 87.2772 408.534C97.7041 411.767 115.191 408.865 115.191 408.865C115.191 408.865 102.008 398.766 92.1644 395.339Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M76.8814 363.743C66.7717 358.378 48.6785 355.877 48.6785 355.877C48.6785 355.877 59.7387 371.018 70.0418 376.04C79.8548 380.823 97.58 380.619 97.58 380.619C97.58 380.619 86.0881 368.63 76.8814 363.743Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M64.0831 329.644C56.4159 323.343 41.4704 318.1 41.4704 318.1C41.4704 318.1 48.2616 332.873 56.1525 338.916C63.668 344.671 78.7667 347.551 78.7667 347.551C78.7667 347.551 71.0657 335.383 64.0831 329.644Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M58.439 293.141C51.8304 285.737 37.8673 278.261 37.8673 278.261C37.8673 278.261 42.3092 293.901 49.1785 301.084C55.7209 307.926 70.1982 313.09 70.1982 313.09C70.1982 313.09 64.4573 299.884 58.439 293.141Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M58.7179 264.872C53.0715 256.71 40.1355 247.572 40.1355 247.572C40.1355 247.572 42.6172 263.64 48.5495 271.615C54.1996 279.21 67.9306 286.118 67.9306 286.118C67.9306 286.118 63.8599 272.305 58.7179 264.872Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M62.0416 231.48C57.3076 222.758 45.4316 212.279 45.4316 212.279C45.4316 212.279 46.1675 228.521 51.2059 237.088C56.0046 245.248 68.9113 253.595 68.9113 253.595C68.9113 253.595 66.3528 239.424 62.0416 231.48Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M73.1342 203.987C70.8266 194.334 62.0777 181.132 62.0777 181.132C62.0777 181.132 58.5723 197.008 61.2143 206.59C63.7305 215.715 74.028 227.127 74.028 227.127C74.028 227.127 75.2357 212.777 73.1342 203.987Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M82.9994 176.932C81.2427 168.791 74.3696 157.705 74.3696 157.705C74.3696 157.705 71.4232 171.163 73.4478 179.242C75.3761 186.936 83.5034 196.493 83.5034 196.493C83.5034 196.493 84.5992 184.347 82.9994 176.932Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M98.7276 148.748C97.6485 140.489 91.7131 128.875 91.7131 128.875C91.7131 128.875 87.6667 142.044 89.018 150.262C90.3051 158.089 97.6164 168.284 97.6164 168.284C97.6164 168.284 99.7104 156.269 98.7276 148.748Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M113.956 126.926C113.882 118.597 109.391 106.352 109.391 106.352C109.391 106.352 103.785 118.936 104.135 127.257C104.468 135.183 110.496 146.185 110.496 146.185C110.496 146.185 114.025 134.511 113.956 126.926Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M134.574 107.572C135.477 99.2916 132.455 86.6033 132.455 86.6033C132.455 86.6033 125.411 98.4429 124.782 106.748C124.182 114.657 128.877 126.291 128.877 126.291C128.877 126.291 133.751 115.112 134.574 107.572Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M154.396 92.9433C157.357 85.1583 157.63 72.118 157.63 72.118C157.63 72.118 147.83 81.8 145.127 89.6779C142.554 97.1811 144.165 109.622 144.165 109.622C144.165 109.622 151.699 100.033 154.396 92.9433Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M171.812 80.8387C174.193 74.5498 174.391 64.0074 174.391 64.0074C174.391 64.0074 166.482 71.8179 164.311 78.1824C162.243 84.2441 163.568 94.3056 163.568 94.3056C163.568 94.3056 169.644 86.5659 171.812 80.8387Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M198.692 443.65C196.117 432.498 186.145 417.195 186.145 417.195C186.145 417.195 181.962 435.473 184.923 446.545C187.744 457.091 199.517 470.343 199.517 470.343C199.517 470.343 201.038 453.806 198.692 443.65Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M170.613 427.16C169.377 416.473 161.497 400.976 161.497 400.976C161.497 400.976 155.45 417.407 157.066 428.07C158.605 438.227 168.444 452.051 168.444 452.051C168.444 452.051 171.739 436.892 170.613 427.16Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M146.046 406.015C147.234 395.323 143.023 378.455 143.023 378.455C143.023 378.455 133.451 393.115 132.639 403.869C131.865 414.112 138.359 429.789 138.359 429.789C138.359 429.789 144.964 415.753 146.046 406.015Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M126.252 386.156C129.149 376.737 128.489 361.363 128.489 361.363C128.489 361.363 117.693 373.605 115.108 383.112C112.646 392.166 115.476 406.672 115.476 406.672C115.476 406.672 123.615 394.734 126.252 386.156Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M108.288 363.605C111.185 354.186 110.525 338.812 110.525 338.812C110.525 338.812 99.7288 351.054 97.144 360.561C94.6822 369.615 97.5123 384.121 97.5123 384.121C97.5123 384.121 105.651 372.183 108.288 363.605Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M95.1357 330.802C100.218 322.359 103.285 307.28 103.285 307.28C103.285 307.28 89.8552 316.557 85.0543 325.16C80.4818 333.354 79.7303 348.114 79.7303 348.114C79.7303 348.114 90.5072 338.491 95.1357 330.802Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M91.6716 299.947C99.1812 293.566 106.898 280.252 106.898 280.252C106.898 280.252 91.21 284.762 83.9161 291.384C76.9692 297.692 71.5493 311.442 71.5493 311.442C71.5493 311.442 84.8326 305.758 91.6716 299.947Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M88.9686 274.719C96.4782 268.338 104.195 255.025 104.195 255.025C104.195 255.025 88.507 259.534 81.2131 266.157C74.2662 272.464 68.8463 286.214 68.8463 286.214C68.8463 286.214 82.1296 280.53 88.9686 274.719Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M89.2022 245.76C96.6527 241.602 105.493 231.427 105.493 231.427C105.493 231.427 91.476 232.409 84.1651 236.819C77.202 241.019 70.2209 252.009 70.2209 252.009C70.2209 252.009 82.417 249.548 89.2022 245.76Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M96.577 219.431C104.963 217.854 116.577 211.013 116.577 211.013C116.577 211.013 102.973 207.493 94.6403 209.353C86.7038 211.124 76.5941 219.328 76.5941 219.328C76.5941 219.328 88.9404 220.867 96.577 219.431Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M106.488 194.203C114.873 192.626 126.488 185.786 126.488 185.786C126.488 185.786 112.884 182.266 104.551 184.125C96.6147 185.896 86.505 194.1 86.505 194.1C86.505 194.1 98.8513 195.64 106.488 194.203Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M117.121 170.92C125.64 170.433 138.037 165.141 138.037 165.141C138.037 165.141 124.998 159.902 116.495 160.676C108.397 161.413 97.3169 168.25 97.3169 168.25C97.3169 168.25 109.363 171.363 117.121 170.92Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M131.222 150.143C139.754 150.294 152.511 145.943 152.511 145.943C152.511 145.943 139.9 139.745 131.363 139.882C123.232 140.012 111.673 146.002 111.673 146.002C111.673 146.002 123.453 150.006 131.222 150.143Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M147.281 132.213C155.793 132.813 168.762 129.14 168.762 129.14C168.762 129.14 156.495 122.286 147.962 121.973C139.836 121.674 127.977 127.047 127.977 127.047C127.977 127.047 139.53 131.666 147.281 132.213Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M162.636 117.122C170.038 118.972 182.553 117.495 182.553 117.495C182.553 117.495 173.496 109.222 165.998 107.637C158.857 106.128 146.871 109.363 146.871 109.363C146.871 109.363 155.894 115.437 162.636 117.122Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M181.862 100.821C189.052 101.86 200.293 99.5476 200.293 99.5476C200.293 99.5476 190.303 92.9652 183.077 92.1685C176.196 91.4096 165.792 95.2342 165.792 95.2342C165.792 95.2342 175.314 99.8748 181.862 100.821Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M194.481 83.8153C202.449 80.7628 212.651 71.954 212.651 71.954C212.651 71.954 198.637 70.9255 190.772 74.2466C183.28 77.4096 174.802 87.29 174.802 87.29C174.802 87.29 187.225 86.5951 194.481 83.8153Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M379.992 84.7228C379.992 84.7228 516.199 159.054 487.691 320.332C464.757 450.074 299.005 494.565 299.005 494.565'
        stroke='var(--primary-color)'
        strokeWidth='3'
      />
      <path
        d='M327.168 460.536C331.875 450.093 344.677 437.01 344.677 437.01C344.677 437.01 345.246 455.752 340.175 466.042C335.345 475.842 321.165 486.564 321.165 486.564C321.165 486.564 322.883 470.045 327.168 460.536Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M350.485 488.623C361.538 491.773 376.369 502.524 376.369 502.524C376.369 502.524 357.817 505.755 346.863 502.224C336.431 498.86 323.751 486.416 323.751 486.416C323.751 486.416 340.419 485.755 350.485 488.623Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M384.726 469.69C396.15 470.972 412.568 479.126 412.568 479.126C412.568 479.126 394.81 485.375 383.42 483.7C372.572 482.106 357.995 471.927 357.995 471.927C357.995 471.927 374.322 468.523 384.726 469.69Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M417.36 447.479C428.857 447.544 446.052 453.915 446.052 453.915C446.052 453.915 429.062 462.008 417.558 461.548C406.601 461.11 391.019 452.532 391.019 452.532C391.019 452.532 406.891 447.42 417.36 447.479Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M443.832 421.624C455.178 419.779 473.2 423.205 473.2 423.205C473.2 423.205 457.804 434.006 446.384 435.463C435.507 436.851 418.706 430.98 418.706 430.98C418.706 430.98 433.499 423.304 443.832 421.624Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M467.526 395.339C478.383 391.576 496.728 391.859 496.728 391.859C496.728 391.859 483.432 405.139 472.435 408.534C461.961 411.767 444.395 408.865 444.395 408.865C444.395 408.865 457.638 398.766 467.526 395.339Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M482.877 363.743C493.032 358.378 511.206 355.877 511.206 355.877C511.206 355.877 500.097 371.018 489.747 376.04C479.89 380.823 462.086 380.619 462.086 380.619C462.086 380.619 473.629 368.63 482.877 363.743Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M495.733 329.644C503.434 323.343 518.447 318.1 518.447 318.1C518.447 318.1 511.625 332.873 503.699 338.916C496.15 344.671 480.983 347.551 480.983 347.551C480.983 347.551 488.719 335.383 495.733 329.644Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M501.402 293.141C508.04 285.737 522.066 278.261 522.066 278.261C522.066 278.261 517.604 293.901 510.704 301.084C504.132 307.926 489.59 313.09 489.59 313.09C489.59 313.09 495.357 299.884 501.402 293.141Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M501.122 264.872C506.794 256.71 519.788 247.572 519.788 247.572C519.788 247.572 517.295 263.64 511.336 271.615C505.661 279.21 491.868 286.118 491.868 286.118C491.868 286.118 495.957 272.305 501.122 264.872Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M497.783 231.48C502.538 222.758 514.468 212.279 514.468 212.279C514.468 212.279 513.729 228.521 508.668 237.088C503.847 245.248 490.883 253.595 490.883 253.595C490.883 253.595 493.453 239.424 497.783 231.48Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M486.641 203.987C488.959 194.334 497.747 181.132 497.747 181.132C497.747 181.132 501.268 197.008 498.614 206.59C496.087 215.715 485.743 227.127 485.743 227.127C485.743 227.127 484.53 212.777 486.641 203.987Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M476.732 176.932C478.496 168.791 485.4 157.705 485.4 157.705C485.4 157.705 488.36 171.163 486.326 179.242C484.389 186.936 476.226 196.493 476.226 196.493C476.226 196.493 475.125 184.347 476.732 176.932Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M460.933 148.748C462.017 140.489 467.979 128.875 467.979 128.875C467.979 128.875 472.043 142.044 470.686 150.262C469.393 158.089 462.049 168.284 462.049 168.284C462.049 168.284 459.946 156.269 460.933 148.748Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M445.636 126.926C445.711 118.597 450.222 106.352 450.222 106.352C450.222 106.352 455.853 118.936 455.501 127.257C455.166 135.183 449.111 146.185 449.111 146.185C449.111 146.185 445.567 134.511 445.636 126.926Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M424.926 107.572C424.018 99.2916 427.054 86.6033 427.054 86.6033C427.054 86.6033 434.13 98.4429 434.762 106.748C435.364 114.657 430.649 126.291 430.649 126.291C430.649 126.291 425.752 115.112 424.926 107.572Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M405.015 92.9433C402.041 85.1583 401.766 72.118 401.766 72.118C401.766 72.118 411.611 81.8 414.325 89.6779C416.91 97.181 415.292 109.622 415.292 109.622C415.292 109.622 407.724 100.033 405.015 92.9433Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M387.521 80.8387C385.13 74.5498 384.931 64.0074 384.931 64.0074C384.931 64.0074 392.875 71.8179 395.055 78.1824C397.133 84.2441 395.802 94.3056 395.802 94.3056C395.802 94.3056 389.699 86.5659 387.521 80.8387Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M360.52 443.65C363.107 432.498 373.123 417.195 373.123 417.195C373.123 417.195 377.326 435.473 374.351 446.545C371.518 457.091 359.691 470.343 359.691 470.343C359.691 470.343 358.164 453.806 360.52 443.65Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M388.725 427.16C389.967 416.473 397.882 400.976 397.882 400.976C397.882 400.976 403.956 417.407 402.333 428.07C400.787 438.227 390.904 452.051 390.904 452.051C390.904 452.051 387.594 436.892 388.725 427.16Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M413.403 406.015C412.209 395.323 416.439 378.455 416.439 378.455C416.439 378.455 426.054 393.115 426.87 403.869C427.647 414.112 421.124 429.789 421.124 429.789C421.124 429.789 414.489 415.753 413.403 406.015Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M433.285 386.156C430.376 376.737 431.038 361.363 431.038 361.363C431.038 361.363 441.883 373.605 444.479 383.112C446.952 392.166 444.109 406.672 444.109 406.672C444.109 406.672 435.935 394.734 433.285 386.156Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M451.329 363.605C448.42 354.186 449.082 338.812 449.082 338.812C449.082 338.812 459.927 351.054 462.524 360.561C464.996 369.615 462.154 384.121 462.154 384.121C462.154 384.121 453.979 372.183 451.329 363.605Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M464.541 330.802C459.436 322.359 456.355 307.28 456.355 307.28C456.355 307.28 469.845 316.557 474.667 325.16C479.26 333.354 480.015 348.114 480.015 348.114C480.015 348.114 469.19 338.491 464.541 330.802Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M468.021 299.947C460.477 293.566 452.726 280.252 452.726 280.252C452.726 280.252 468.484 284.762 475.811 291.384C482.789 297.692 488.233 311.442 488.233 311.442C488.233 311.442 474.89 305.758 468.021 299.947Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M470.736 274.719C463.192 268.338 455.441 255.025 455.441 255.025C455.441 255.025 471.199 259.534 478.526 266.157C485.504 272.464 490.948 286.214 490.948 286.214C490.948 286.214 477.605 280.53 470.736 274.719Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M470.501 245.76C463.017 241.602 454.137 231.427 454.137 231.427C454.137 231.427 468.217 232.409 475.561 236.819C482.555 241.019 489.567 252.009 489.567 252.009C489.567 252.009 477.317 249.548 470.501 245.76Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M463.093 219.431C454.67 217.854 443.004 211.013 443.004 211.013C443.004 211.013 456.668 207.493 465.039 209.353C473.011 211.124 483.166 219.328 483.166 219.328C483.166 219.328 470.764 220.867 463.093 219.431Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M453.138 194.203C444.715 192.626 433.048 185.786 433.048 185.786C433.048 185.786 446.713 182.266 455.083 184.125C463.055 185.896 473.21 194.1 473.21 194.1C473.21 194.1 460.809 195.64 453.138 194.203Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M442.457 170.92C433.9 170.433 421.448 165.141 421.448 165.141C421.448 165.141 434.545 159.902 443.086 160.676C451.22 161.413 462.35 168.25 462.35 168.25C462.35 168.25 450.25 171.363 442.457 170.92Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M428.292 150.143C419.723 150.294 406.908 145.943 406.908 145.943C406.908 145.943 419.576 139.745 428.151 139.882C436.318 140.012 447.929 146.002 447.929 146.002C447.929 146.002 436.097 150.006 428.292 150.143Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M412.162 132.213C403.612 132.813 390.585 129.14 390.585 129.14C390.585 129.14 402.907 122.286 411.477 121.973C419.64 121.674 431.552 127.047 431.552 127.047C431.552 127.047 419.948 131.666 412.162 132.213Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M396.738 117.122C389.303 118.972 376.732 117.495 376.732 117.495C376.732 117.495 385.829 109.222 393.361 107.637C400.534 106.128 412.573 109.363 412.573 109.363C412.573 109.363 403.51 115.437 396.738 117.122Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M377.426 100.821C370.204 101.86 358.913 99.5476 358.913 99.5476C358.913 99.5476 368.947 92.9652 376.205 92.1685C383.117 91.4096 393.568 95.2342 393.568 95.2342C393.568 95.2342 384.003 99.8748 377.426 100.821Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
      <path
        d='M364.75 83.8153C356.747 80.7628 346.499 71.954 346.499 71.954C346.499 71.954 360.576 70.9255 368.476 74.2466C376.001 77.4096 384.517 87.29 384.517 87.29C384.517 87.29 372.039 86.5951 364.75 83.8153Z'
        fill='var(--primary-color)'
        stroke='var(--primary-color)'
      />
    </svg>
  );
}

SupporterBadgeEmblem.displayName = 'SupporterBadgeEmblem';

export default SupporterBadgeEmblem;
