# 通用语法

先试着读一个英文句子：

> The spectacular aurora light displays that appear in Earth’s atmosphere around the north and south magnetic poles were once mysterious phenomena.

虽然有点长，虽然可能有些生词，没关系，没有时间限制，所以可以慢慢折腾，不认识的词全都查一遍词典，耐心读完，试试理解它的意思。

在讲解这个句子之前，让我先向你介绍一个相当简单的 “全球语言通用语法框架”：

句子是由词汇构成的，而词汇通常主要被划分为四种词性，名词、动词、形容词、副词 —— 这是地球上所有的语言都同样具备且一致的分类。

它们之间是什么样的关系呢？

> * 名词可以发出一个动作（比如，李笑来正在讲课；你们正在听课）
>
> * 名词也可以是一个动作的受体或目标（比如，李笑来正在给你们讲课…… 你们就是李笑来讲课的这个动作的受体或者目标）
>
> * 形容词是用来修饰名词的（比如，正在讲课的李笑来是开心的，正在听课的你们是认真的）
>
> * 副词可以用来修饰动词或者形容词，甚至可以修饰另外一个副词……（副词什么时候能够修饰名词啊？错的时候……）（比如，你们中的很多人正在记笔记，记笔记这个动作是什么样的呢？你们正在认真地记笔记…… 认真地就是副词。当然，这个认真肯定多少是虚伪的，并且自己并不知道的，因为你们从来都是这个样子，无论上什么课，第一节课的时候都非常认真，因为每次你们都决心重新做人…… 我倒要看你们能够认真多久？
>
>   所以，你看，“你们不由自主地可事实上是虚伪地认真着” —— 这就是副词在修饰形容词。当然，我要是这么说，“你们正在由衷地虚伪地认真记着笔记”，这句话虽然有点拗口，可它还是一个合法的句子 —— 在这个句子中，你们，这个名词，正在发出一个动作，记；而由衷地，这个副词在修饰虚伪地这个副词，然后这个由副词修饰副词构成的副词性成分，正在修饰着记着个动词，而笔记，是记这个动作的受体。

名词是干嘛的？名词是用来描述你能够感知的事物的，管它是抽象的还是具体的；（苹果与桔子，都是具体的；痛苦或者幸福就是抽象的）

动词是干嘛的？动词是用来描述你能够感知的动作的，管它是抽象的还是具体的；（你打电话，是能看得见的动作，是具体的；你思考，就是别人看不见摸不着的动作，是抽象的）

形容词是干嘛的？形容词用来描述你对你能够感知到的那个事物的感知；（比如说，你能感知一个苹果很大还是很小，你的痛苦程度是否严重，你的幸福程度是否像是喝了蜜一样……）

副词是干嘛的？副词在修饰动词的时候，和形容词修饰名词一样，用来描述你对你能够感知的那个动作的感知。

> * 当副词修饰形容词的时候，比较拗口，你可能要重复听几遍才行；当副词修饰形容词的时候，它用来描述你对你能够感知的那个事物的感知的感知……
> * 再进一步，若是你遇到一个副词在修饰另外一个副词的时候，它是干什么的呢？它用来描述你对你能够感知的那个事物的感知的感知的感知……（这句话里一共 4 个感知）（再拿 “你们正在由衷地虚伪地认真记着笔记” 这句话做例子，我能感知到你记笔记的这个动作，记，然后，我也能感知到记这个动作是认真的，再进一步，我能感知到认真的这个状态是虚伪的，再然后，我还能感知到这个虚伪的状态其实还真的是相当发自内心的……）

还有一个重点。那就是，所有的语言都一样，句子的核心是 “动词”，每个句子，无论多复杂，总是有且只有一个动词，语言学家们甚至习惯于把它称作句子的 “根”（“root”）。

以上关于 “词性的本质”，在我讲写作课的时候，无论是中文写作课，还是英文写作课，都是必讲的 “不可或缺的基础知识”。到此为止，这个小小的框架，是所有语言通用的，无论是中文、韩文、日文，还是英文俄文法文德文、或者西班牙语、意大利语，都一样。因为语言文字就是人类用来 “记录感知”、“传递感知” 的，所以，一切的文字，无论哪一种，核心都是且只能是 “感知”。

接下来我们再看看这个框架与英文相关的扩展。在英文之中，每一种词性，都可以由很多种结构构成：

> * 名词性成分：名词、代词、名词性词组、名词性从句；
> * 动词性成分：动词，以及包含各种时态的结构；
> * 形容词性成分：形容词、名词、代词的所属、介词结构、分词结构、动词不定式，等等，以及定语从句；
> * 副词行成分：副词、介词结构、分词结构、动词不定式，等等，以及定语从句；

以上的各种结构，就是所有英文语法书中重点讲解的内容，基本上占整个语法书的 $\frac{1}{4}$，还有恨不得 $\frac{2}{3}$ 是关于动词及其时态的，剩下的就是其它零零碎碎且又不可或缺的细节。

于是，我们可以从另外一个角度去理解所谓的 “句子结构” —— 无论是英文，还是任何其他语言都一样 —— 我们要区分的都一样，到底是 “哪些词加起来构成了哪一种成分？” 与此同时，成分与成分之间的关系既简单又确定。从这个角度望过去，句子结构分析并不复杂。

句子的核心其实是 “动词”，一个简单句中只有一个动词，甚至被称为 “句跟”（Root） —— 这个关键，在人类的任何语言中都一样，没有任何其它可能性。

搞清成分之间的关系

* 向前预测

* 向后回顾

不确定：

* 每个词可能有多个意思甚至多个词性
* 构成某个特定成份的词的数量不确定

确定：

* 成分与成分之间的可能的关系单一且确定
* 无论什么时态每个简单句中只有一个动词

—— 以上的 “语法有关知识点”，实际上是全世界所有语言通用的。本质上是因为人类的大脑结构是一样的，不论是哪一个种族，不论使用的是什么语言…… 所以，到最后，人类在相互 “传递感知” 的时候，用的只能是底层一致的逻辑与方式。

在此基础上，我们再讲一个全人类通用的 “文字处理流程”。都是一样的，就是在持续输入的过程中不断重复做同样三件事情：

* 向后回顾
* 向前预测
* 不断验证

虽然语言多种多样，可人类处理信息的方式统一地都是且只能是 “线性的”，一点一点逐步获取信息输入；与此同时，都是在不断回顾、预测并验证的过程中完成所谓的 “理解”。

现在我们再回过头来看看这句话：

> The spectacular aurora light displays that appear in Earth’s atmosphere around the north and south magnetic poles were once mysterious phenomena.

读到 *The*，我们 “预测” 这应该是一个名词性词组的开头，于是，心里相当于提了一个问题，“到底是什么呢？”。

然后我们看到了一个形容词，“spectacular”，名词还没出现呢，于是，我们当然会预测接下来会看到名词，相当于又一次提问，“绚丽的什么啊？”

很快这个 “预测” 就被验证通过了，果然接着读入的就是名词性成分，“aurora light”…… 我们已经依次输入了 “The spectacular aurora light”，“那绚丽的极光”，嗯，这是个名词性词组，好像没什么问题。

然后，我们就会自然而然地接着 “预测”，这个 “名词”，即，“我们所能够感知到的事物”，会跟着一个动词，要么接着名词性成分或者形容词性成分的 be 动词，要么是一个动作，即，“是什么” 或者 “干了什么” 这两种情况之一，到底是哪一种情况呢？

接着读入的是 “displays”，之前的验证好像又通过了，于是，我们继续预测，“那绚丽的极光展示了什么呢？” 接着读下去，“that appear in ...” 嗯？哪里不对！动词后面应该是名词性成份，作为这个动作的受体，又或者，跟着的应该是修饰它的副词性成份…… 可现在读进来的，明显是个 “定语从句” 的结构…… 如此看来，“displays” 并不是动词，它应该是被后面这个 “定语从句” 说修饰的，前面的名词性成份的一部分，整个名词性成份应该是 “The spectacular aurora light displays”，相当于中文的 “那绚丽的极光的展现”（或者用 “现象” 这个词更容易理解一些）……

纠正过我们之前的错误预测之后，我们又继续读下去，继续预测，继续提问。我们在想，那既然是一个定语从句，那么，它就应该是在描述对这个我们能够感知到的事物（名词）—— 即，“那绚丽的极光的展现” —— 的感知（形容词）…… 等我们读完整个从句，“that appear in Earth’s atmosphere around the north and south magnetic poles”，反应过来，原来就是限定了一下，“那在地球南北两磁极的大气层里出现的绚丽的极光的展现”……

到此为止，读进来的全部，依然是个名词性成分（一个名词性词组被一个定语从句所修饰），那么，我们接着预测，接着提问：它是什么？还是它干了什么？读进来的是 “were”，哦，原来是在说，它是什么…… 那么，它到底是什么呢？继续读，“once” 副词，“曾经是”，曾经是什么呢？“曾经是神秘的现象”。

到此为止，我们完整无误地理解了整个句子。但，请注意，我们刚刚不断预测不断验证，不断提问不断回答的过程，不是 “翻译过程”，而是 “理解过程”。成年人在学第二语言的时候，经常会因为 “翻译不顺” 而苦恼，也经常会把自己 “翻译不顺” 误解为 “理解有误”。

“翻译” 与 “理解” 不是一回事。“翻译” 在 “理解无误” 的基础上，还要依赖对母语的连续运用。字对字翻译的话，我们好像已经有了一个版本：

> 那在地球南北两磁极的大气层里出现的绚丽的极光的展现曾经是神秘的现象。

这里的 “display” 若是被翻译成了 “展现” 怎么读着都别扭，于是，为了通顺且易于理解，可能要换成 “现象” —— 可是，“现象” 绝对不是英汉词典里为 “display” 所提供的 “翻译” 选项……

>那在地球南北两磁极的大气层里出现的绚丽的极光现象曾经是神秘的现象。

换了之后，还是别扭，因为中文译文中现在有两个 “现象”…… 想了想，干脆把第一个现象删掉吧：

> “那在地球南北两磁极的大气层里出现的绚丽的极光曾经是神秘的现象。”
>
> 或者
>
> “那在地球南北两磁极的大气层里出现的绚丽的极光现象曾经非常神秘。”

也就是说，为了所谓的 “信达雅”，相当于弄不好要把 “display” 干脆去除，好像中文译文才足够通顺且易于理解…… 显然，这样的 “工作”，是第二语言学习过程中暂时并不必要的负担。所以，轻易不要把时间精力浪费在 “翻译” 上，重点关注自己的 “理解” 过程。更为微妙的是，即便你想翻译，到最后你会发现，“翻译” 的真正瓶颈，其实更多在自己的母语水平上 —— 这一点颇有些让人难为情，甚至会引发恼羞成怒的情绪。

这个例句的 “难度” 是故意设计的，它曾经是一句在 TOEFL 考试里难倒了无数学生的句子 —— 甚至有些老师也把这个句子的结构分析错了。可时代变了，今天我们有无数极其方便的工具，可以帮我们分析任何复杂的句子…… 比如，Python 就有个语言结构分析模块，叫做 spaCy，几行代码就够，还能给出图解，详细拆解每个词、词组、结构、从句之间的关系…… 有了这样的工具之后，你不需要任何老师，因为压根就没有能难住你的语法结构。上一张你你看到的其实是同一张图，就是这句话的 “语法结构”。

![](/Users/joker/Library/Mobile Documents/com~apple~CloudDocs/iDesktop/英语自学家庭路径/../images/dep-graph.svg)

有必要补充一下，“翻译” 是 “用外语” 的另外一种方式，它难度事实上极高，因为它不仅需要外语的精通，更需要母语的精通，并且，即便是两种语言都精通的情况下，也有时候依然做不到 “信达雅” —— 毕竟，每种语言背后都是一个完整且又复杂的文化系统，不可能做到 100% 相同或者想通。于是，也常常不得不求助于 “意译”。

> Reading makes a full man, conference a ready man, and writing an exact man.
>
> > 通常翻译：“读书使人深沉，谈话使人机敏，而写作使人思想精确。”
>
> > 我的翻译：“读书使人完整，讨论使人完备，写作使人完善。”
>
> We are all just prisoners here, of own own divce.
>
> > 一个曾令我震惊的翻译：“吾辈自囚沉诸欲。”

所以，在第二语言习得的时候，不要让 “翻译” 这项 “高级技能” 称为自己的 “拖累” —— 要知道，“翻译”，那可是要在很久之后且你若有兴趣才可以做的事情。

于是，从此之后，没什么句子可以难倒你了，不是你多聪明，仅仅是因为你学会了使用新的工具而已。