# 疯狂输入

有 “生学硬练” 作为起步，有 “人工智能” 作为最好的老师，有 “自己” 作为 “教练” 不停地给自己做 “心理建设”，甚至不惜 “超频” 地提高自己大脑的 “效能阈值”，真用 “注意力” 填充用来 “训练” 的时间…… 别说 “学门外语” 了，做什么不行呢？

当然，在 “学外语” 这事儿上，“人工智能” 实在是个彻头彻尾的 “解脱”。

说来好笑，地球上没有任何其他国家的人 “学外语” 比 “中国人学外语” 更划算…… 先不说别的，中国人学门英语，用处很多，毕竟人类许多个世纪积累下来的 “知识” 的确大多都更为完整地使用英文记录…… 比如，美国人 “学外语” 相对就很惨。*[The Case Against Education: Why the Education System Is a Waste of Time and Money](https://www.amazon.com/Case-against-Education-System-Waste/dp/0691174652)* 的作者 Bryan Caplan，乔治梅森大学的经济学教授，苦笑说，“美国人也花很多时间 ‘学外语’，比如他就在学校里浪费了不少时间学西班牙语…… 结果呢？终生用不上。为了不至于浪费，学以致用，出国旅行的时候，专门选择西班牙餐厅，结果呢？到了地方发现服务员说的还是英语……”

更大的关键在于，客观地看，从 “语言习得” 的角度出发，“中文” 几乎是天下 “学习成本” 最高，“学习曲线” 最陡峭的语言。别的不说，单说中文的文字是 “象形文字” 这一点就够了，尤其现在人们使用的还是 “经过改良的象形文字” —— 虽然 “象形” 但早已经彻头彻尾地 “不象形”…… “象形文字” 的学习难度就是比 “字母文字” 不知道要高多少倍。所以，中国人 “学外语” —— 尤其是 “英语” —— 的时候，“相对难度” 被 “自身难度” 作为基准降低了很多…… 换言之，相对来看，“使用相对更低的成本” 就可以 “换取相对更多的收获”。

“人工智能” 的突然爆发，别说 “中国人学英语的方式” 了，连 “英语国家地区民族” 的 “母语习得方式” 都要因此大幅度改变，甚至干脆颠覆：

> 突然之间，绝大多数 “语文老师”（对英语母语使用者）或者 “英语老师”（对非英语母语使用者）都该 “改行” 了…… 因为 “最好的老师”，只能是 “人工智能”……

过去，“学龄前儿童” 的 “信息获取” 受限，主要原因来自于 “文字能力获得” 所需要的 “时间成本”，尤其是在 “无聊且又无效的古老教育方式（或体系）” 之下，浪费了太多的时间精力。现在呢？别说最近大家使用的 “语音 ChatGPT” 了，在此之前的许多年里，Apple Siri，Google Assitant，Amazon Alexa 等 “智能音箱” 就已经极大丰富了 “学龄前儿童” 的世界。

小朋友们刚开会说话的时候，就开始不停地问 “这是什么呀？”（What），没多久，两岁多一点的时候，吐字不清晰呢，就已经开始不厌其烦地问 “为什么呀？”（Why）…… 全世界都一样，父母们在面对 “What” 的时候，还游刃有余，但，遇到 “Why” 的时候，就捉襟见肘了……

我就被我家小朋友问住过。小朋友才刚刚开始说话，18 个月左右的时候，有一天他摸着自己的耳朵的某个部位，问我，“这是什么呀？” 我一看，愣住了，我真不知道那块软骨叫什么…… 查了一下 [Wikipedia](https://zh.wikipedia.org/?curid=7408978)，找到了答案，英文叫做 “tragus”，中文叫做 “耳屏”，也叫做 “耳珠”。

![](../images/Gray904.png)

若是没有 “搜索引擎”，没有 “智能音箱”，没有 “人工智能” 的时代里，很大一部分小朋友问出来的问题都只有一个全球统一答案，“等你长大了就知道了……” 现在不一样了，就没有找不到答案的问题 —— 关键在于，并不受限于 “文字”。

小朋友如此，成年人呢？更加 “不受限” 了啊！

再进一步，**文字本身并没有多难** —— 尤其是 “拼音文字”，英文总计就 26 个 “字母”，加上 “音标” 也没多少个，甚至不用专门练，只要反复把自己 “暴露” 在大量英文文字之中，就会 “自然习得”，其难度大抵上只不过是为了 “弹钢琴” 学会识别 “五线谱” 差不多 —— 那些 “符号” 其实并不是靠 “死记硬背” 获得的，而是靠 “反复遇到” 进而从 “陌生” 变为 “熟悉” 到最后 “了如指掌”。

有了 “人工智能” 之后，正如我们已经 “演示” 过的那样，我们竟然可以直接跳过所谓的 “基础”，直接 “开口说话”，反正，人工智能给我们生成的文本没有语法错误，给我们生成的语音没有发音错误，我们照说就是了…… 而真实的生活也的确就是如此，**我们说的每一句话，理论上都是别人说过的话 —— 起码，是 “基于” 别人说过的话。**

反过来，一旦我们 “**直接开口说话**”，再回过来去习得基础的 “识字”，难度就会突然讲到 “绝对可以接受” 的程度，而不再是传统学校里的 “外语教学” 基于无奈才那么制定的 “反方向” 给我们造成的那差一点就 “完全不可逾越的障碍”。

从我们的角度望过去，**学校里的一切课程都是 “语文课”**，了不起，文字可以被分为 “自然语言” 和 “人工语言”。可实际上，只要你真正且认真地经历过那已经传承了恨不得两百多年的所谓 “正规教育体系” 你就知道了，学校里在 “自然语言” 这方面的所有 “语文课”，基本上都是 “聊胜于无”。

不说别的，看一看花了那么长时间 “受教育” 的人群，小学六年，中学六年，本科四年，弄不好再搞个研究生两三年，十几年下来，有几个能写出漂亮文章的？别说写文章了，真的有相当一部分大学毕业生，连份 “租房合同” 都不能系统地理解，乃至于上当受骗。这不是夸张，你知道我说的是事实。并且，这也不是中国一个地区的问题，其实，全世界都一样，以上描述的现象，在所有国家都普遍存在。

人群当中，永远只有少数人最终具备了真正的 “**自然语言使用能力**”，能说会写。到最后大多数人即便是受了所谓的 “高等教育”，到最后在生活里也几乎放弃了文字的使用 —— 这一点我在《专注的真相》里专门描述过。那些少数 —— 如果不是极少数的话 —— 靠的从来都不是学校里的 “语文教育”，他们靠的只能是自己，他们怎么做到的？两个字的话，是 “多读”，四个字的话，是 “不停地读” 或者 “疯狂地读”。

“自然语言使用能力”，人群之间的差异有多大呢？你不妨拿自己做个实验。你随便找来一部像样一点的小说 —— 在这里，拿中文小说为例，要么你找一部马伯庸的小说，他的小说很多很多…… 要么你翻一翻 2024 年年初火起来的《繁花》，都一样 —— 你翻翻就知道了，每隔几行就会有一两个 “你自己从来没用过甚至从来没见过的词汇”……

当然，那些词藻可能并不影响你的阅读，你大概猜的出来那是什么意思，或者干脆忽略也可以…… 可那些作者是怎么做的呢？他们在阅读的时候，遇到新词、好词，他们会不断收集，然后，不断变着法地去用它们，日积月累，他们就拥有了更强大的表达能力 —— 这些，都是学校里的 “语文老师” 无能为力的，为什么？就算他们像我一样告诉了你这背后其实并不复杂的道理，那又怎样？**到最后，还不是得靠你自己，靠你自己的注意力填满你自己的时间吗？**

熟练之后，人们的中文阅读速度大约是每分钟 500 字左右。如果每天用 10 分钟去做 “额外阅读”，那么，一年下来，与那些不做 “额外阅读” 的人相比，阅读量差异大约是 182.5 万字，相当于 10 本 “大部头书籍” 的差异。如果每天一小时呢，差异就是 1,095 万字，如果每天两小时呢？三小时呢？

这只是 “仅仅每天 10 分钟” 的差异啊，那些热爱阅读的人，每天何止 10 分钟啊，查理·芒格始终保持自己每天 6 个小时的阅读，你算算，他的脑子里装的东西，与他人相比，差异得有多大？（在英语世界，熟练者阅读英文的速度大约是 350 词左右。）

现在是 “阅读狂欢” 的时代，知识在爆发，并且，知识传播的速度达到了 “瞬间” 的程度。在 Amazon 上，每当 “新书” 出现的时候，你都可以 “秒购” —— “瞬间” 之后，你就可以在各种设备上开始读或者听，没有 “生词” 可以拦住你，因为阅读器内建词典，没有 “难句” 可以拦住你，哪怕是 “未知的语法现象” 或 “陌生的习惯用法” 同样拦不住你，因为阅读器现在都在 “实时翻译” 功能…… 甚至，你可以为自己写个 Python 脚本调用 spaCy 模块，瞬间它就可以帮你分析清楚整个句子的结构，无论哪句子多么复杂（使用 spaCy 的 Jupyter Notebook 参见附录）。

![](../images/dep-graph.svg)

“阅读” 没办法不上瘾的 —— 因为它能消灭 “智商差异”。人类所有真正有意义的知识，都被编码成了 “文字”。文字可传播、可修订、可积累，不同的文字之间的转换也越来越容易，于是，几千年后的今天，一切都在文字之中，进而，未来也只能在文字之中…… 也许有些人 “智商” 的确高，但，差不多只要 “一百本书” 的量，基本上就可以彻底消灭 “智商差异”，因为每本好书，都是 “高手” 们投入了大量时间大量注意力，才获得的结论，每本书都在帮你省时间，每本书省下来的何止是一天两天一年两年…… 若是 “一千本书” 的积累的话，换个说法，你何止是 “千年老妖” 啊！—— 这种量级 “知识储备” 用所谓的 “智商” 怎么拼得过呢？

“阅读自由” 可能是我们作为社会动物终其一生能够获得的最大的 “平等权利”。你能看到的我也能看到，你能读完的我也能读完。只不过，这样宝贵的权利，大多数人对此视而不见，置若罔闻，失去了也不知道心疼。

问题在于，“识字” 的最大好处，不就是 “阅读” 吗？很多人的 “文凭”，无论看起来多高级，了不起是个 “识字证” 而已，因为他们在毕业之后，就基本上停止了阅读，放弃了文字的使用…… 而多语使用者，既然好不容易 “多识了几种字”，难道不应该更加珍惜 “阅读机会” 吗？

总是有人会不由自主地冒出这样的念头，“都可以自动翻译了” 何必一定要 “读外语”？读翻译过来的自己更熟悉的母语，岂不是更快更方便？—— 这就是价值观问题了…… 我们读外语的原因除了获取知识或者信息之外，还有更重要的目的，“健脑” —— 我们觉得健脑很重要，甚至比普通意义的 “健身” 不知道重要多少倍，所以，必须那么做。当然，若是你觉得甚至坚信 “健脑” 不重要，弄不好你觉得连 “健身” 也不重要，那我们为什么一定要说服你呢？反正，到最后，人生的一切其实都是自己选的。

热衷于 “健脑” 的人从来不怕麻烦。不仅读得听得相对更多 —— 那只是 “输入”；还要说得更多写得更多 —— “输出” 比 “输入” 更重要，并且，我们都懂那个道理，“输出会倒逼输入”，“更高质量的输出” 就是需要更多 “更高质量的输入”。所以，我们读完了，还会总结归纳记笔记，还要复述，甚至必要的话还要背诵，反正都是在 “健脑”。

相对于 “健身”，“健脑” 有一个缺点，那就是，不仅 “见效慢”，甚至干脆很难 “见效”。“健身”，通常三两个月就能看出不一样，一切都可以体现在外部，“健脑” 就不一样了，你管它见效快不快，就算快也没办法 “直观体现”。然而，“健脑” 带来的变化，无论是否可以 “直观体现”，它的存在，它的发展，它的迅猛，都是自身无法否认的…… 很多人就是想不开，“健脑” 也好 “健身” 也罢，是 “健” 给谁的啊？只能是自己么，别人能不能看到，有所谓吗？

然而，到最后，“健脑” 的效果最终会逐步展现在 “财富” 方面，无论是 “精神财富” 还是 “物质财富”。一旦 “健脑” 的效果竟然开始展现，它肯定是全方位的 —— 尤其是 “物质财富”。仅仅 “成为多语使用者” 这一项就会保证你相对于他人终其一生多处 30% 以上的收入。

这种 “多语造成的收入差异” 其实不仅仅只针对个人。2013 年的时候，另外[一项研究](https://www.tbsnews.net/analysis/how-knowing-more-one-language-boosts-your-income-588066)（James Foreman-Pech, 2013）经过量化计算得到结论，英国每年大约会损失 3.5% 的 GDP（当年相当于 480 亿英镑），仅仅因为英国人基本都是单语使用者，语言能力不强，并误以为 “全世界都会说英语”。原因也很明显，起码，语言障碍会极大影响贸易。

勤于 “健脑” 的人，“人力资本”（Human Capital）相对更为丰富 —— 因为大脑就是这样，用的越多多好，用的方式也是越多越好。研究表明，多语使用者常常相对拥有更强的记忆能力、理解能力，他们有相对更多的思考模式，[处理信息速度更快](https://news.northwestern.edu/stories/2014/11/bilingual-brains-better-equipped-to-process-information)，解决问题能力更强，[多任务能力更强](https://www.nih.gov/news-events/news-releases/bilinguals-switch-tasks-faster-monolinguals-nih-funded-study-shows)，在多任务重来回切换时速度也更快 —— 很显然，这些都是极为重要的 “职场优势”…… 然而，这一切的好处很早就会开始发挥作用。[纽约大学的一项研究](https://www.sciencedaily.com/releases/2018/06/180612080039.htm)表明，在学校里，多语使用者的学习效率和学习成绩都相对更高。

问题在于，到最后，无论 “钱” 这个东西重不重要，“健脑” 的结果都会终将展现在个体财富积累上，因为人类社会的进步程度，很大程度体现在 “知识变现” 的效率上，那个 动不动就 “空有一身本领”、“有识之士终生不得志” 的时代早就过去了，并且，早就过去很久很久了……