# 音高停顿

虽然 “生学硬练” 最靠谱，但，我们也不是不重视 “方法” 或者 “策略” —— 只不过，无论做什么，总得有个优先顺序；所以，“最重要的最先关注”，只不过是个既自然且又合理的选择。

在过去的若干年里，人工智能辅助的语音合成迅猛发展，今天的 TTS（Text to Speech）已经完善到令人震惊的地步 —— 比如微软的 Natural Sound，或者 Suno-AI 的 Bark。这背后，是一个叫做 “[ToBI](https://en.wikipedia.org/wiki/ToBI)”（Tones and Breaks Indices 的缩写）的语音解析模型，最初的时候是计算机科学家们为了研究如何让机器能够发出像真人一样的声音而制作的模型，最初是针对美式英语设计的，后来发现可以应用到任何语言（无论是英式英语，还是日语、德语、甚至中文）……

这里的 _Tones_，即，所谓的 “**语调**”，主要是 “**音高**”（Pitch）的变化，从一个较高的 “音高” 逐步下来，那就是 “降调”，或者反过来，就是 “升调”，降下来再升上去，那就是所谓的 “降升调”。而所谓的 _Breaks_，就直观了，句子之中，就是有些明显的 “**停顿**” —— 其实，每个音节之间都可能有所停顿，只不过是长短不一而已。

关键在于，音调和停顿，在说话的时候和唱歌的时候一样，会构成所谓的 “**节奏**”……

我们在读英文句子的时候，需要注意的细节极多，然而，就好像计算机科学家们可以用 ToBI 模拟人声一样，**我们可以通过优先只关注 “停顿” 和 “音高” 就能达到相对更好的效果**。

也就是说，在读句子的时候，有以下重点需要注意：

> - 意群之间的停顿（breaks）
> - 音节的音高（pitches）

在这些要素中，我们关注的重点顺序依次是：**停顿 > 音高**。

这个关注顺序与传统英语课堂上的 “教学方法” 和 “练习方法” 恰好是截然相反的。我们在传统的课堂上，都是从 “音素”（“辅音” 和 “元音”）开始，老师要尝试着让学生把每一个音素都学得练得足够 “标准”，然后才会关注 “音节”，要到了一段时间之后，才开始讲解 “声调” —— 乃至于很多人在半途而废之前压根就没重视过音调…… 至于 “停顿” 么，从来没有关注过，相反，所谓的 “高阶学生”，整天研究的是 “连读”，而不是 “停顿”。

我需要举一个你可能想象不到的例子，才能让你明白 “**仅仅优先关注停顿和音高竟然就可以大幅度改善**” 的原因 —— 这跟我们的大脑工作机制有关。

我曾在 [Reddit](https://www.reddit.com/r/moviecritic/comments/195b90j/can_you_name_all_the_films_depicted_in_this/) 上看到过一个 Infinite Zoom Art，里面有很多电影海报（视频我给放到 `video` 目录下了 [infinite-zoom-art-movie-poster.mp4](vidio/infinite-zoom-art-movie-poster.mp4)）：

![](../images/posters.png)

这些电影海报的有趣之处在于那些 “大量被忽略掉的细节”。你仔细看看，所有的海报都一样，其中所有 “人物” 的脸都是空的，压根就没画眉毛眼睛鼻子嘴这些一般来说被认为是重要的细节 —— 可你竟然看一眼就知道人家画的是什么…… 也就是说，当我们去识别一样东西的时候，不管什么，靠的不是 “所有细节”，而是 “少数重点”。这是人类的大脑能够迅速完成 “模式识别” 的关键 —— 也就是说，只需要 “少数重点存在”，识别就可以完成。再换言之，别说 “细节准不准确”，哪怕 “很多细节缺失”，在 “少数重点存在” 面前，都完全无所谓。

我们可以通过计算机程序，帮助我们把一句话讲述过程中的 “语调” 变化，即，“音高” 变化（pitch contour）分析出来，给我们一个直观的视觉展示，以便我们能够 “看” 到 “停顿” 的位置，以及 “音高” 的各种由低到高，或者反过来由高到低的过程。

比如，下面这样一句话：

> Yet, it is a fact of life that an unlettered peasant is considered ignorant.

<video src="../videos/yet-it-is-a-fact-of-life.mp4"></video>

> 以上的截图视频，用的是我自己 2003 年 10 月份为自己写的一个 Demo 工具（[ToBI Player](https://github.com/xiaolai/tobiplayer)），现在已经有另外一个完整的[应用程序](https://github.com/zuodaotech/everyone-can-use-english/tags)（EnJoy）了，虽然只是 alpha 版，还需要很久的时间去完善。

因为有声波的展示，大的停顿之处是直观可见的：

> Yet, | it is a fact of life | that an unlettered peasant is considered ignorant.

而后，只要反复边听边看，就会找出大大小小几乎所有的 “停顿”，比如，“that an unlettered peasant” 中有一处可能会令很多中国英语老师无比惊讶的 “停顿”，“that an | unlettered peasant”…… “an” 和 “unlettered” 之间并没有他们以为的 “连读”，相反，竟然是他们从未想到的 “停顿”。

然后，语调展示（Pitch Contour）也很直观。`Yet` 是升调，`fact` 升上去，`life` 降下来，`unlettered paseant`，`un` 这个音节升上去了一点点之后，剩下的 `lettered`就平着保持在那里，而后 `pa` 到更高一点的地方降下来。`is considered ignorant` 里，`con` 这个音节略微降下来一点，而后 `ig` 这个音节明显被拉高了……

—— 好了，这些重点搞清楚了，就可以开始 “跟读” 了。

刚开始的时候，很多 “音素” 会读不准，不着急，这些细节的问题，要么可以通过 “生学硬练” 逐步消灭掉，要么需要以后我们用 “更细致的方法” 逐一消灭。我们不可能一下子解决所有问题的，但，“停顿” 与 “音高”（ToBI）不仅足够简单，易于理解，练起来也足够容易，并且还足够有效，甚至，干脆是 “惊人地有效”。

**绝大部分人的大脑在声音方面是有这样那样局限的** —— 这实际上很明显。在生活中，至少有一半的人压根就无法很好地模仿他人的说话语气。这种 “模仿” 需要相对更强的声音输入能力、分辨分析能力、记忆能力，以及对自己声音的控制能力，不细想可能不知道，一细想就明白了，这肯定不是所有人都具备的能力。除了这些能力可能欠缺之外，很多人在分辨音高这事儿上可能并不及格…… 这个 “很多人” 中的 “很多” 比例有多高呢？大致来看，比例应该不低于 $\frac{4}{5}$，甚至可能更多 ——— 你压根就没必要怀疑这个估算，你只要看看人群中到底有多少人唱歌足够好听就大概知道完全并认同了。

反正我自己是很清楚自己的。我的声音记忆力就是很短很差，我的音高分辨能力几近于零，唱歌的时候不用吉他辅助，音就能跑到天涯海角，节奏也会不知不觉地乱掉…… 别说我讲英文吃力了，就连我讲我自己的母语，都事实上并不轻松。我的母语算是有两个，一个是中文，一个是朝鲜语 —— 我是朝鲜族，所以，从小生活在双语环境里。我的中文顶多算是合格而已，声音不好听，有时候吐字不足够清晰，反正比那些播音员不知道差到哪里去了。所以，每当我录课的时候，我需要返工的地方特别多。

而我的朝鲜语呢？许多年后，我回老家，有时候讲朝鲜语，那些不认识我的人会用朝鲜语说，“你们看这个汉族人朝鲜语说的真好！”

<audio src="../audios/korean-spoken-by-chinese.mp3"></audio>

—— 也就是说，我的朝鲜语虽然还算流利，但在他们的耳朵里已经明显带着 “外国腔” 了…… 那可曾经是我的 “母语” 之一啊！可 “母语” 又怎样呢？只要用的少，并且长时间用得少，就会退化。实际上，我的朝鲜语有过前后三次的 “失语”。所谓的 “失语”，就是有比较长的一段时间完全不用的话，突然就说不出来了，虽然听还是都听得懂。

最为关键的是，**语音的塑造，无论如何都需要很长时间** —— 反正比绝大多数第二语言学习者想象的长很多倍。在这一点上，传统教学理论和方法都太操之过急了…… 其实，压根就没有任何一个人类在学习 “发声” 的时候一上来就能做到 “标准”，婴儿从大约一岁左右开始咿呀，得大约需要至少两年半的时间才可以开始做到 “基本上吐字清晰” —— 绝大多数 “英语学习者”，事实上在过往的几年、十几年甚至几十年里，从未有真正意义上的 “一年内投入至少一千小时的注意力” —— 不是吗？反正，我自己是。

在自我训练的时候，不要指望有人在旁边监督你，更不能指望有人能够在旁边一边监督一边帮你挑错 —— 就算有这种服务，那它也应该是超级昂贵且又时间成本上很高的东西…… 我们绝大多数人就是支付不起这种幻想中才能存在的服务。

另外一个格外需要注意的地方是，一定要 “大声”，尽量 “大声”，就是那种上学的时候，被老师叫起来，当着全班同学朗读课文的声音。起码应该是你平日里正常跟人说话的时候使用的音量。“略小的声音” 甚至 “嘟嘟囔囔” 都是折损训练效果的，**必须大声，尽量大声。**当然，没必要 “喊”，适当保护嗓子还是很有必要的。

还有一个就是 “跟读材料” 的选择。

在 “启动任务” 中，我们都是 “说己想说”，而后使用 TTS 引擎生成的语音。这很好，但，再过一段时间，就要逐步 “放大模仿范围”，这个时候，最好使用 “真人语音”，而不是 TTS 生成的语音 —— 因为 TTS 再好，再像真人，它也缺个东西，“情绪”。

人在说话的时候 “情绪” 是无论如何都存在的，哪怕 “没有情绪” 也是一种情绪。所以，某种意义上，“有声书” 片段，可能是更好的 “跟读材料”。或者，截取出来的 “影视对话片段” 可能更好一些，因为毕竟是 “戏”，情绪只能更饱满，甚至更夸张。

我不觉得 “有趣” 在这件事情上有多大的重要性。但，不能 “干巴巴” 地跟读，要 “拿腔拿调” 地模仿。这很关键，因为你毕竟是人，所以你最终要掌握的，是 “**像人一样自然地说话 —— 不管用的是哪种语言**”，不是吗？

最后补充一个提醒，在 “起步” 的时候，不要图篇幅过大，哪怕一天三个小时下来，重复的只有两三句话，也是可以的。之所以从 “一分钟” 开始，就是因为那是绝大多数人都可以用来起步的篇幅。并且，“篇幅较短” 的另外一个好处就是，恰恰可以因此做到 “短时间内足量重复”。

至于更为细节的 “音素”，需要过一段时间之后才开始 “微调”。任何一段话，大抵上都会包括一种语音的所有 “音素”，每一个 “辅音”、每一个 “元音”，大抵上都可以练到 —— “一段话” 不够的话就 “几段话”。所有的 “微调”，都要建立在 “足够的生学硬练” 基础之上，一上来就 “微调”，借用工程学词汇，就叫 “过早优化” —— 据说，“过早优化” 是一切工程的 “万恶之源”。
