# 重中之重

一百多年前，英国有个生理学家，名字叫做阿奇博尔德·希尔（Archibald Hill），1886 年出生，1922 年获得诺贝尔医学奖。把自己的大部分职业生涯时间都投入到了一个他个人感兴趣的问题上：

> 人究竟能跑多快、多久、多远？

因为他自己就是个热爱跑步的人。希尔起初的认知也很直观：

> 最好的跑步成绩，源自于运动员的肌肉机能，而其中，绝大部分是心脏机能。

换言之，心肌功能越强大，跑步能力越强…… 所以，想要把自己的跑步成绩逼到理论极限，那就等同于把自己的心脏机能逼到极限。换言之，如果我的心脏能比你的心脏向跑步肌肉输送更为充足的血液，我就能跑得比你更快。谁的心脏机能最强，谁的跑步成绩就最高。希尔的几乎所有实验数据都支持这个结论。

很多年之后，有人读到了希尔的论文之后，想到个好主意 —— 这个看似简单直观的 “理论” 是可以赚钱的！赛马！只要掌握了每一个参赛马匹的心脏机能数据，就可以 “合理” 预测每一匹马的比赛成绩，不是吗？说干就干！

结果呢？赔的一塌糊涂。在赛马场上，跑得最快的马，从来都不一定是心脏机能最强的那匹马，无论尝试多少次，相对于心脏机能这项指标来看，能跑第一更像是随机的，反正不是心脏机能决定的。

又过了很多年，有人不服气，决定用马拉松比赛的数据核实希尔的理论 —— 很多人不知道的是，马拉松比赛也有人下注的…… 事实上，对赌徒来说，天下的一切事情都可能成为赌博标的。

结果呢？还是一样，希尔的理论得不到真实数据的支持。忍不住用这个理论作为依据下注的人同样赔得一塌糊涂。

又过了很多年，希尔终于弄清了事情的原委，也因此彻底改变了科学家们对运动表现 —— 甚至任何工作表现 —— 的看法。

> 运动成绩不仅仅是你的体能的表现 —— 准确地讲，是你的大脑在那一特定的时刻面对特定的风险与回报是否肯于接纳的表现。

许多年后，脑科学家们对此的解释更为清楚：

> 大脑的首要任务是确保你的生存，即，回避死亡。

如果你的身体不顾一切地开足马力，那么你很快就会筋疲力尽，不堪一击。所以，你的大脑会设定一个效能上的 “效能阈值”，比如，75% 就是你的大脑允许你的身体能够发挥的最大效率，太高了有危险，不划算，相对于风险来说，回报不够高 —— 当然，太低了也不划算。这就好像你开的汽车里有个 “调速器”，也是这样的，它不会允许你的汽车速度达到 “峰值”，否则你的发动机很快就会报废……

但，在赛场上，有很多其它因素存在，比如，马会被骑手 “吓着”，然后，它的大脑对风险回报的看法会发生变化，有可能把阈值从 75% 提高到 90%，甚至 100%…… 于是，它的速度就不一样了。更直接的效果是，也许其他的马心脏机能相对更强，但，当某一匹马虽然心脏机能不一定最强，可当它的 “效能阈值” 被抬高到一定程度的时候，其它的马就比不上它了。

在马拉松比赛里也是如此。比如，有的人是为了自己比赛，有的人是为了家庭，有的人是为了国家比赛，所以对 “回报” 的看法不同；再比如，比赛的奖金对每个选手的 “诱惑程度” 是不一样的，所以，每个人的大脑对 “回报” 的看法不同…… 与此同时，每个人的大脑对 “风险” 的看法与感受也不相同…… 到最后，真正决定成绩的，在心脏机能基础之上，是那属于每个人都不一样的 “效能阈值”。

更为惊人的是，有些时候，那个 “效能阈值” 有可能超出 “100%”…… 看似不可能。你肯定听说过那个惊人的故事，在战争中，一位母亲为了救出自己的孩子，徒手掀起一辆翻倒的吉普车，还能腾出一只手把压在车下的孩子一点一点拉出来…… 这就好像电脑的 CPU 其实可以短时间 “超频” 工作一样，人们在特殊的情况下，在回报与风险比例惊人的情况下，会爆发出难以想象的 “潜能”。

某种意义上，阿奇博尔德·希尔的研究，开启了一个新的领域，叫做 “专业”（Expertise）—— 一代又一代的科学家在研究为什么有些人比另外一些人更专业、甚至最专业，他们究竟是如何做到的，以及人们如何才能达到那样的顶峰…… 到了 2018 年，牛津出版了一本书，叫做《牛津专业手册》（The Oxford Handbook of Expertise），专门介绍科学家们在这个领域里的研究成果 —— 其实是一本读起来比较艰涩的 “论文集”。

这本书里最惊人的结论之一就是：

> 到最后，无论在哪个领域 —— 你能想到的所有领域，包括但不限于，跑步、足球、篮球、骑马、下棋、弹奏、唱歌、跳舞、手术、手艺、生产、组织、管理、多语、科学、技术、创作，等等等等 —— 都一样，达到超群水准甚至巅峰水准的核心关键，并不在于 “天分”（Talents），也不在于 “技巧”（Techniques），而是在于 “动力”（Motivations）—— 并且总是如此 —— 就是那个 “大脑对风险回报比评估之后决定是否接纳的程度”，因为你的大脑会根据它决定你的身体效能的 “效能阈值”，这才是影响你最终表现的最关键因素。

按照排序来看，惊人或者过人的成绩，主要根源，按照重要性排列的话，在于：

> * 动机
> * 专注
> * 策略
> * 其它

最重要的因素，其实是 “强大的动机”，或者说 “强大的欲望” —— 想要做好、想要超群、想要成功、甚至想要杰出的欲望。这是大脑的工作机制决定的，因为出于自我保护的机制和需求，大脑会根据风险和回报确定一个可接受的 “效能阈值”，让你的身体及其机能在一定的范围内工作。也就是说，在不知不觉之间，你的大脑为你设定的 “效能阈值”，不管合理与否，在暗中决定了你任何工作的最终 “表现” 或者 “成绩”。

再进一步，你的大脑为你设定的 “效能阈值”，其实是你的 “认知” —— 你的所有知识、经验、见识，以及整个社会对你的影响构成的总和 —— 所决定的。可问题在于，你的 “认知” 正确吗？充分吗？深入吗？…… 一连串的疑问。

其实，我们甚至没必要争论 “自己的认知是否正确”…… 因为，从历史上来看，别说你我了，整个人类的 “认知” 就没有 “正确” 过，人类的 “认知” 一直是在 “发展” 的，不断改良、不断进步的，没有什么 “正确”，顶多只有 “越来越接近正确”，没有什么 “充分”，只有 “越来越充分”，没有什么 “深入”，只有 “越来越深入”……

换言之，我们每个人的 “认知”，在每时每刻都有可能 “瞬间” 就变成 “落后的认知”，在必要的时候，必须 “改良” —— 在 “认知” 这个至关重要的方面态度固执，拒绝改良拒绝进步的人，历史上也好，现实中也罢，比比皆是，无所不在，永远占绝大多数。至于为什么，对他们来说，就好像是张洪量的歌词那样，“没有理由没有原因”，只不过是前一句歌词要反过来，“莫名我就讨厌你” —— 绝大多数人讨厌改变。

其实呢，绝大多数人讨厌改变，也同样是受自我大脑影响的 —— 还是出于同样的根源，大脑的自我保护机制。大脑的首要任务是保证自我生存，所以，在能够 “生存” 的状态下，一切最好都保持不变…… 问题在于说，这种 “认知” 在原始时代再正确不过了，“生存” 本身已经是天大的难题，在那样的环境里，一切的 “追求” 只不过是充足的食物而已……

唐代的诗人杜甫，自家房子被毁之后，放声大哭，“安得广厦千万间，大庇天下寒士俱欢颜，风雨不动安如山……” 说实话，“居者有其屋”，其实一直以来都是很奢侈的。哪怕是 “人人都可以吃饱” 也只不过是发达国家最近一小段时间才勉强做到的事情 —— 解放后，中国曾经经历过所谓的 “三年困难时期”（1959-1961），那期间有几千万人非正常死亡…… 这只不过是 60 年前的事情而已。当然，即便是今天，世界上还有很多落后地区，依然没有消灭 “贫穷” 和 “饥饿”。

仅仅短短几十年不过百年而已的温饱，很难一下子改变人类几十万年来通过基因积累的 “习惯”，从人类进化历史的角度去看，大多数人的大脑在 “温饱” 不是问题，也就是说，“生存” 不是问题的情况下，“追求” 的欲望并不是很高，甚至，从底层感受上来看，“更多更高的追求” 好像没有必要，相对于过去，人们对某个目标或者方向产生 “极高追求” 的难度，实在是相对太高了，一方面总是感觉没必要，另外一方面更是感觉完全不可及甚至干脆不可望 —— “盼望的望”，“不可望”，就是 “压根看不到” —— 人们常说，什么东西 “可望不可及”，而我们刚刚说的 “极高追求”，“望都望不到”。

对 “大脑自我保护机制” 的深入了解，有助于极大提高任何 “学习成绩”。这就是 “认知改变” 带来的 “生活改变”。

我们刚刚经历的，就是 “认知改变”、“认知改良”、“认知进步”…… 在此之前，我们不知道决定自己专业程度、工作学习成绩的最大最重要的因素竟然并不是我们之前强调过的 “专注” —— 尽管 “专注” 在当时看起来无比的重要；也不是一直以来被所有人都认为最重要的 “策略”，竟然是 “动机”，那个被 “大脑自我保护机制” 所设定的 “效能阈值”……

我们还发现，“满足于温饱”，竟然是绝大多数人 “习惯性拒绝改变” 的根源，又，竟然还是出自同样的根源，那个无比重要的 “大脑自我保护机制”，既然温饱不是问题了，生存不是问题了，绝大多数人的 “效能阈值” 被设定为极低的一个刻度上…… 从这个角度望过去，所谓 “懒惰” 或者 “好吃懒做” 的 “人性”，其实是有所来历有所解释的。

 —— 可问题在于，今天，我们事实上生活在一个相对于短短几十年前 “充满了无限可能性的时代”，若是我们的大脑把自己的 “效能阈值” 设置得那么低，实在是太不划算了吧？

