## 自我纠正

“自学” 过程中，最头痛的一个难点是，“我怎么知道我做得对不对？好不好？” 有时候，当别人指出错误的时候，我们也难免疑惑 “你怎么就知道你是正确的”？

对于 “思考” 进行 “思考”，有个专门的词汇，叫做 “**元认知**”（Meta-recoginition）—— 这是谁都会，但谁都需要想尽一切办法强化的 “认知能力”，其方式倒既简单又统一：“不断反思”。这样的方法不仅古老，并且东西方都一样，孔子说，“吾日三省吾身”，苏格拉底说，“不自省的生活不值得过。”（“An unexamined life is not worth living.）

想象一下就知道了，学会 “**跳出来像旁观者一样观察自己**” 的确不容易。

“录音机” 甚至 “摄影机” 解决了很大的问题。有很多之前无法被注意到的细节，都会被 “如实详尽” 地记录下来，以供随后的分析。马，尤其是奔跑的马，是人类格外喜欢的绘画对象之一。[1878 年](https://en.wikipedia.org/wiki/The_Horse_in_Motion)之前，人们画奔跑的马，四条马腿的位置通常都是错的…… 若是没有摄像机的话，人类的眼睛会被视觉缓存所干扰，乃至于误以为马在奔跑的时候四腿的位置是另外一个样子。

我父亲那一代人，通过使用 “收音机” 降低了学外语的难度，对他们来说，那可算是 “突然之间可以随意听到外语”…… 到我这一代，70 后，“录音机” 开始起作用，不仅可以 “听到外语”，还可以 “特定的部分反复听”；甚至，可以录下自己的声音，而后通过反复检查改进自己。对 90 和 00 后来说，“互联网” 和它所分发的内容，无论是图文、音频还是视频，都起了巨大的作用，不仅各类内容的 “量” 大到不可想象的地步，关键在于，大部分内容竟然还是 “免费” 的…… 并且，“互联网” 还自带 “搜索引擎”，到最后，无论什么内容都有可能找到。

人们 “说外语” 的时候，不再表达生硬且单一，在不断丰富的同时，开始无限接近以前可望不可及的所谓 “地道”。与此同时，录音，早就在电脑上了，甚至用不着早些年那么昂贵的 “磁带”，语音分析工具也逐步丰富起来，人群之中，“说外语毫无口音” 的人开始多起来…… 到了我离开新东方的时候，2008 年前后，很多中学生考个托福满分，已经见怪不怪了。

2023 年，基于 “大语言模型” 的 “人工智能” 爆发。“突然之间”，几乎所有一切都不再是问题了。你想说什么，让人工智能帮你重新组织，不用担心它返回来的文字版本是否有语法错误，不用担心措辞是否足够地道，不用提前担心自己的词汇量够不够，不用担心它返回来的语音版本发音是否准确 —— 突然之间，完全没什么可担心的了……

—— 只剩下一件事：自己练得是否足够多，乃至于最终真的能做得足够好？

也许，再过一段时间，“人工智能” 也能在 “语音纠正” 方面做到更为有效，更为惊人 —— 只不过，起码目前还不太行。微软有个语音评分的系统，试用过之后觉得效果一般。但，我们也的确有理由在这方面不再等待也不用指望 “人工智能”……

因为，**“纠正” 这事儿，从来都应该首先是 “自我纠正”** —— 这是 “自学” 的 “基础能力”，也是 “自学者” 的 “基本功”。想要掌握 “自学能力”，就是要学会 “跳出来像旁观者一样观察自己” —— 有了这个能力，再加上 “一年内至少投入一千小时的注意力”，无论学什么，都算得上是如虎添翼，所向披靡。

人们在学习过程中犯错的时候，所谓 “具备共性” 的 “常见错误” 再多也不如 “**个性化错误**” 多 —— 并且，每个人所面对的 “个性化错误” 不仅更多，还千奇百怪，且常常难以归纳分类，更为关键的是，“个性化错误” 才是更重要的错误，才是更需要纠正的错误……

有时候，犯点 “常见错误” 并不奇怪，甚至无所谓。即便是在母语使用者群体里，“常见错误” 也非常普遍。拿中文举例个例子，以下有多少字你一直以来都读错了？

> * 氛围、气氛（fēn）
> * 强劲有力（jìng）
> * 订正（dìng）
> * 胴体（dòng）
> * 契诃夫（hē）
> * 一哄而散（hòng）
> * 窗明几净（jī）
> * 连累（lei 或 lěi）
> * 模板（mú）
> * 心宽体胖（pán）

换言之，“大家几乎都错” 的时候 “你也错了”，还真可以算是无所谓，但，“大家都没错”，但 “只有你自己错了”，就相对更可怕。

再比如，英文中有一对元音，短元音 /ɪ/ 和长元音 /iː/，听起来差不多，但它们之间有细微的差异。长元音 /iː/ 的发音方式和中文拼音中的 ī、í、ǐ、ì 是一样的；但，英文的短元音 /ɪ/，其实是 /e/ 和 /i/ 之间的音，不是 “长元音 /iː/ 的更短版本”…… 于是，以中文为母语的人讲英文的时候，尤其是那种单词末尾有短元音 /ɪ/ 的词汇，都会发成 /i/，而不是 /ɪ/ —— 这就是所谓的 “常见错误”。可实际上，问题并不大，因为 “反正大家都这样”……

但是，facade（也写作：façade）被我读成 `'fækeɪt`，或者 specific，被我读成 `spesɪfɪk` —— 那就是我自己的 “个性化错误” 了…… 这种错误总是相对更显眼，甚至干脆感觉上 “更致命”，你想想看是不是这样？

所以，总体上来看，“**纠错**” 这事儿，还真只能主要靠自己做。因为从数量上来看，需要自己解决的就是相对更多，把这些任务放到别人身上，非常不合理。从这个角度望过去，“一厢情愿地希望所有错误都有人帮忙解决”，其实是软弱的表现而已。没办法，就得自己来。只不过，过去没有人像我这样提醒你而已。

当然，最初的时候，所有人都面临同样的可怕问题：“并不知道自己错了” —— 也因为如此总是重复犯错。但，熟练的 “自学者” 凭经验知道，这并不是 “永恒” 的现象。

起初的时候，一定要有 “足量的生学硬练” —— 因为它是 “起步” 最快最靠谱的方式。一旦起步了，“生学硬练” 足够多了，总是有 “进步”…… 所有的 “进步”，不仅是 “更熟练” 而已，总是还带着 “细微的改良”，所以，有 “进步” 经验的人，对 “改良” 的观察和感受是相对更为强烈的 —— 这就是 “自我纠正” 的基础。于是，经过一段时间之后，就会发现自己开始逐步拥有越来越强的 “自我纠正能力”。

**“自我纠正能力” 只能是 “积累” 出来的，并且，貌似也只能 “靠自己积累”** —— 然而，它恰恰是一个人 “自学能力” 是否足够强的最关键指标。如果这个能力差，甚至这个能力缺席，那么，“自学” 实话说就完全无从谈起了。

“**帮别人纠错**” 也是个好办法。这么做的好处很精妙。你看，很多属于你自己的 “个性化错误” 并不是别人可以想象到的，所以，别人很难主动帮你纠正。同时，反过来，其他人的 “个性化错误”，也有可能是自己 “正在犯”，甚至 “将要犯” 的错误。你可能会奇怪，“我怎么可能感受到别人正在犯我自己正在犯的错误？” 你的理由是，“因为我自己正在犯那个错误，说明我自己不知道那是错误”。别笑，人就是这样，自己正在犯的错误自己并不知道，但是别人犯了同样的错误，却可以瞬间指出。“帮别人纠错” 的好处在这个微妙的细节上有着更好的体现 —— 因为它能帮你解决很多你没想到要解决的问题。

不过，“帮别人纠错”，有个细节格外值得注意，那就是：

> **要提前征得同意。**

如果，对方心里默认你是老师，即相当于是早就同意了 “你随时帮他指出错误” —— 可若非如此，“被指出错误” 是非常令人苦恼的事情，难道你自己不这么觉得吗？但，我这个建议的出发点并不是因为这个，我是为了自己避免掉进 “固守型人格陷阱”。因为 “随意指出他人错误”，会不由自主地引发自己的优越感，进而更加迷恋 “横向比较”，甚至，往往冒着 “被讨厌的风险” 也要忍不住那么做，实在是太可怜了。

除非确认对方乐于接受被人指出错误，对方乐于改进以便进步，否则的话，对方犯错就犯错了吧，尤其是 “语音上的错误”，那是语言文字传递信息过程中最不重要的点而已。比如，有人不小心把 “女红” 读成了 nǔ hóng，而不是 nǔ gōng，又怎样呢？你已经知道对方说的是什么了，不就可以了嘛？人家读错那么长时间，也没影响人家的生活啊？！更没影响你的生活。

出于这个原因及其相关原则，“结伴学习” 总是非常有效 —— 不是一群人，而是仅仅两三个人。因为人数太多的话，就可能非常混乱。但，两三个人相互之间要提前做好约定，大家在没有任何心理负担的情况下相互帮忙纠错，纠错效率极高的同时纠错覆盖面也足够广。又由于之前已经有相互的约定，所以，一切的 “纠错” 都很心情愉快，以进步为导向。

另外一个同样值得重视的细节是：

> **一次只纠一个错。**

错误常常不是 “知道了就能直接完全改正” 的，尤其在学外语的时候，尤其是语音上的习惯，尤其是成年人在语音上的习惯，常常是 “即便知道了也需要很多很多的练习” 才能彻底纠正。换言之，纠正一个错误可能真的需要很长时间。另外，“纠错” 是个格外耗费 “脑力” 的事情，一方面要 “做”，一方面还要用 “元认知” 观察自己 “做得过程”，在 “纠错” 的时候，还要 “重新协调” 各个器官……

所以，一次被纠错太多，不一定是好事，因为 “真的招架不住”。

“自我纠错能力” 的积累，在任何领域都一样，学什么都一样，都是 “从无到有”，“从零散到系统” 的过程。所以，必须为自己准备一个 “纠错记录”，而后不断补充，不断整理。

你可能会误以为 “那些错误已经被纠正了，那么，那些 ‘已经纠正的错误’ 又何必在花时间精力那么麻烦地记录下来？” 做好记录、不断补充、不断整理的时间精力绝对不会浪费，恰恰相反，是很好的投资 —— 因为这个过程，实际上是我们的大脑在逐步建立全面完善且清晰准确的 “自我认知” 的过程，“人贵自知”，而所谓的 “自知” 真不是随随便便就能获得的。这个过程中培养的、积累的、锻炼的，就是 “自省” 的能力。

还有些时候，“发现了错误” 之后，竟然找不到什么方法可以解决…… 没关系，先记下来，“只要心心念念就总有出路”。在 “启动任务” 整个 “作业” 中，最后有一条：

> 在这个过程中，遇到的困难（解决的、未解决的），以及想到的可能的解决方案，练习过程中的感悟。（一个文本文件）

这是必须养成的习惯，“记录问题”，无论解决的还是未解决的。对于那些 “尚未解决” 的“问题”，尤其要经常 “回顾”，把它们 “刻” 在脑子里。老师教学生说，“要带着问题读书”，因为这样才能 “找到答案”。我的看法是，“要带着问题生活”，因为答案不一定只在书里，在任何地方都有可能。但，找到答案的前提，还真就只能是 “脑子里带着问题”，不是吗？

