export const IPA_CONSONANTS: { [key: string]: string[] } = {
  plosive: [
    "p",
    "b",
    "t",
    "d",
    "ʈ",
    "ɖ",
    "c",
    "ɟ",
    "k",
    "g",
    "q",
    "ɢ",
    "ʔ",
    /* extensions */ "ɡ",
  ],
  nasal: ["m", "ɱ", "n", "ɳ", "ɲ", "ŋ", "ɴ", "n̩"],
  trill: ["ʙ", "r", "ʀ"],
  tapOrFlap: ["ⱱ", "ɾ", "ɽ"],
  fricative: [
    "ɸ",
    "β",
    "f",
    "v",
    "θ",
    "ð",
    "s",
    "z",
    "ʃ",
    "ʒ",
    "ʂ",
    "ʐ",
    "ç",
    "ʝ",
    "x",
    "ɣ",
    "χ",
    "ʁ",
    "ħ",
    "ʕ",
    "h",
    "ɦ",
  ],
  lateralFricative: ["ɬ", "ɮ"],
  affricate: ["tʃ", "ʈʃ", "dʒ"], // very incomplete, there are many others
  approximant: ["ʋ", "ɹ", "ɻ", "j", "ɰ", /* extensions */ "w"],
  lateralApproximant: ["l", "ɭ", "ʎ", "ʟ"],
};

export const IPA_VOWELS: { [key: string]: string[] } = {
  close: ["i", "yɨ", "ʉɯ", "u", "iː"],
  closeOther: ["ɪ", "ʏ", "ʊ", "ɨ", "ᵻ"],
  closeMid: ["e", "ø", "ɘ", "ɵ", "ɤ", "o", "ə", "oː"],
  openMid: ["ɛ", "œ", "ɜ", "ɞ", "ʌ", "ɔ", "ɜː", "uː", "ɔː", "ɛː"],
  open: ["æ", "a", "ɶ", "ɐ", "ɑ", "ɒ", "ɑː"],
  rhotic: ["◌˞", "ɚ", "ɝ", "ɹ̩"],
  diphtongs: [
    "eɪ",
    "əʊ",
    "oʊ",
    "aɪ",
    "ɔɪ",
    "aʊ",
    "iə",
    "ɜr",
    "ɑr",
    "ɔr",
    "oʊr",
    "oːɹ",
    "ir",
    "ɪɹ",
    "ɔːɹ",
    "ɑːɹ",
    "ʊɹ",
    "ʊr",
    "ɛr",
    "ɛɹ",
    "əl",
    "aɪɚ",
    "aɪə",
  ],
};

export const IPA_MAPPINGS: { [key: string]: string } = {
  p: "p",
  b: "b",
  t: "t",
  d: "d",
  ʈ: "t",
  ɖ: "d",
  c: "k",
  ɟ: "g",
  k: "k",
  g: "g",
  q: "k",
  ɢ: "g",
  ʔ: "t",
  ɡ: "g",
  m: "m",
  ɱ: "m",
  n: "n",
  ɳ: "n",
  ɲ: "j",
  ŋ: "ŋ",
  ɴ: "ŋ",
  n̩: "n",
  ʙ: "r",
  r: "r",
  ʀ: "r",
  ⱱ: "",
  ɾ: "t",
  ɽ: "r",
  ɸ: "f",
  β: "v",
  f: "f",
  v: "v",
  θ: "θ",
  ð: "ð",
  s: "s",
  z: "z",
  ʃ: "ʃ",
  ʒ: "ʒ",
  ʂ: "s",
  ʐ: "z",
  ç: "",
  ʝ: "j",
  x: "k",
  ɣ: "g",
  χ: "h",
  ʁ: "r",
  ħ: "h",
  ʕ: "",
  h: "h",
  ɦ: "h",
  ɬ: "",
  ɮ: "",
  tʃ: "tʃ",
  ʈʃ: "tʃ",
  dʒ: "dʒ",
  ʋ: "v",
  ɹ: "r",
  ɻ: "r",
  j: "j",
  ɰ: "w",
  w: "w",
  l: "l",
  ɭ: "l",
  ʎ: "j",
  ʟ: "l",
  i: "i",
  yɨ: "iː",
  ʉɯ: "uː",
  u: "uː",
  iː: "iː",
  ɪ: "ɪ",
  ʏ: "ɪ",
  ʊ: "ʊ",
  ɨ: "i",
  ᵻ: "i:",
  e: "e",
  ø: "e",
  ɘ: "ə",
  ɵ: "ə",
  ɤ: "ɑː",
  o: "o",
  ə: "ə",
  oː: "oː",
  ɛ: "e",
  œ: "æ",
  ɜ: "ɝ",
  ɞ: "əː",
  ʌ: "ʌ",
  ɔ: "ɔ",
  ɜː: "ɝː",
  uː: "uː",
  ɔː: "ɔː",
  ɛː: "e:",
  eː: "i:",
  æ: "æ",
  a: "ɑ",
  ɶ: "ɑ",
  ɐ: "ə",
  ɑ: "ɑ",
  ɒ: "ɑː",
  ɑː: "ɑː",
  "◌˞": "",
  ɚ: "ɚ",
  ɝ: "ɝ",
  ɹ̩: "r",
  eɪ: "eɪ",
  əʊ: "oʊ",
  oʊ: "oʊ",
  aɪ: "aɪ",
  ɔɪ: "ɔɪ",
  aʊ: "aʊ",
  iə: "iə",
  ɜr: "ɜr",
  ɑr: "ɑr",
  ɔr: "ɔr",
  oʊr: "oʊr",
  oːɹ: "ɔːr",
  ir: "ir",
  ɪɹ: "ɪr",
  ɔːɹ: "ɔːr",
  ɑːɹ: "ɑːr",
  ʊɹ: "ʊr",
  ʊr: "ʊr",
  ɛr: "er",
  ɛɹ: "er",
  əl: "əl",
  aɪɚ: "aɪ",
  aɪə: "aɪə",
  ts: "tz",
};
